/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyUsage;
import org.apereo.cas.util.cipher.BaseStringCipherExecutor;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcJwtAccessTokenCipherExecutor
extends BaseStringCipherExecutor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcJwtAccessTokenCipherExecutor.class);
    protected final LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> defaultJsonWebKeystoreCache;
    protected final OidcIssuerService oidcIssuerService;

    public String getName() {
        return "OpenID Connect JWT Access Tokens";
    }

    public String encode(Serializable value, Object[] parameters) {
        this.getJsonWebKeyFor(OidcJsonWebKeyUsage.SIGNING).map(jwks -> (JsonWebKey)jwks.getJsonWebKeys().get(0)).map(PublicJsonWebKey.class::cast).ifPresent(key -> this.setSigningKey(key.getPrivateKey()));
        this.getJsonWebKeyFor(OidcJsonWebKeyUsage.ENCRYPTION).map(jwks -> (JsonWebKey)jwks.getJsonWebKeys().get(0)).ifPresent(key -> {
            this.setEncryptionKey(key.getKey());
            this.setContentEncryptionAlgorithmIdentifier("A128CBC-HS256");
            this.setEncryptionAlgorithm("RSA-OAEP-256");
        });
        return super.encode(value, parameters);
    }

    public String decode(Serializable value, Object[] parameters) {
        this.getJsonWebKeyFor(OidcJsonWebKeyUsage.ENCRYPTION).map(jwks -> (JsonWebKey)jwks.getJsonWebKeys().get(0)).map(PublicJsonWebKey.class::cast).ifPresent(key -> {
            this.setEncryptionKey(key.getPrivateKey());
            this.setContentEncryptionAlgorithmIdentifier("A128CBC-HS256");
            this.setEncryptionAlgorithm("RSA-OAEP-256");
        });
        this.getJsonWebKeyFor(OidcJsonWebKeyUsage.SIGNING).map(jwks -> (JsonWebKey)jwks.getJsonWebKeys().get(0)).map(PublicJsonWebKey.class::cast).ifPresent(key -> this.setSigningKey(key.getPublicKey()));
        return super.decode(value, parameters);
    }

    private Optional<JsonWebKeySet> getJsonWebKeyFor(OidcJsonWebKeyUsage usage) {
        String issuer = this.oidcIssuerService.determineIssuer(Optional.empty());
        LOGGER.trace("Determined issuer [{}] to fetch the JSON web key", (Object)issuer);
        return Objects.requireNonNull((Optional)this.defaultJsonWebKeystoreCache.get((Object)new OidcJsonWebKeyCacheKey(issuer, usage)));
    }

    @Generated
    public LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> getDefaultJsonWebKeystoreCache() {
        return this.defaultJsonWebKeystoreCache;
    }

    @Generated
    public OidcIssuerService getOidcIssuerService() {
        return this.oidcIssuerService;
    }

    @Generated
    public OidcJwtAccessTokenCipherExecutor(LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> defaultJsonWebKeystoreCache, OidcIssuerService oidcIssuerService) {
        this.defaultJsonWebKeystoreCache = defaultJsonWebKeystoreCache;
        this.oidcIssuerService = oidcIssuerService;
    }
}

