/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.Attribute;
import COSE.CoseException;
import COSE.CounterSign;
import COSE.CounterSign1;
import COSE.Encrypt0Message;
import COSE.EncryptMessage;
import COSE.HeaderKeys;
import COSE.MAC0Message;
import COSE.MACMessage;
import COSE.MessageTag;
import COSE.Sign1Message;
import COSE.SignMessage;
import COSE.Signer;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public abstract class Message
extends Attribute {
    protected boolean emitTag = true;
    protected boolean emitContent = true;
    protected MessageTag messageTag = MessageTag.Unknown;
    protected byte[] rgbContent = null;
    List<CounterSign> counterSignList = new ArrayList<CounterSign>();
    CounterSign1 counterSign1;

    public static Message DecodeFromBytes(byte[] rgbData) throws CoseException {
        return Message.DecodeFromBytes(rgbData, MessageTag.Unknown);
    }

    public static Message DecodeFromBytes(byte[] rgbData, MessageTag defaultTag) throws CoseException {
        Signer cs;
        Message msg;
        CBORObject messageObject = CBORObject.DecodeFromBytes((byte[])rgbData);
        if (messageObject.getType() != CBORType.Array) {
            throw new CoseException("Message is not a COSE security Message");
        }
        if (messageObject.isTagged()) {
            if (messageObject.GetAllTags().length != 1) {
                throw new CoseException("Malformed message - too many tags");
            }
            if (defaultTag == MessageTag.Unknown) {
                defaultTag = MessageTag.FromInt(messageObject.getMostInnerTag().ToInt32Unchecked());
            } else if (defaultTag != MessageTag.FromInt(messageObject.getMostInnerTag().ToInt32Unchecked())) {
                throw new CoseException("Passed in tag does not match actual tag");
            }
        }
        switch (defaultTag) {
            case Unknown: {
                throw new CoseException("Message was not tagged and no default tagging option given");
            }
            case Encrypt: {
                msg = new EncryptMessage();
                break;
            }
            case Encrypt0: {
                msg = new Encrypt0Message();
                break;
            }
            case MAC: {
                msg = new MACMessage();
                break;
            }
            case MAC0: {
                msg = new MAC0Message();
                break;
            }
            case Sign1: {
                msg = new Sign1Message();
                break;
            }
            case Sign: {
                msg = new SignMessage();
                break;
            }
            default: {
                throw new CoseException("Message is not recognized as a COSE security Object");
            }
        }
        msg.DecodeFromCBORObject(messageObject);
        CBORObject countersignature = msg.findAttribute(HeaderKeys.CounterSignature, 2);
        if (countersignature != null) {
            if (countersignature.getType() != CBORType.Array || countersignature.getValues().isEmpty()) {
                throw new CoseException("Invalid countersignature attribute");
            }
            if (countersignature.get(0).getType() == CBORType.Array) {
                for (CBORObject obj : countersignature.getValues()) {
                    if (obj.getType() != CBORType.Array) {
                        throw new CoseException("Invalid countersignature attribute");
                    }
                    CounterSign cs2 = new CounterSign(obj);
                    cs2.setObject(msg);
                    msg.addCountersignature(cs2);
                }
            } else {
                cs = new CounterSign(countersignature);
                ((CounterSign)cs).setObject(msg);
                msg.addCountersignature((CounterSign)cs);
            }
        }
        if ((countersignature = msg.findAttribute(HeaderKeys.CounterSignature0, 2)) != null) {
            if (countersignature.getType() != CBORType.ByteString) {
                throw new CoseException("Invalid Countersignature0 attribute");
            }
            cs = new CounterSign1(countersignature.GetByteString());
            ((CounterSign1)cs).setObject(msg);
            msg.counterSign1 = cs;
        }
        return msg;
    }

    public byte[] EncodeToBytes() throws CoseException {
        return this.EncodeToCBORObject().EncodeToBytes();
    }

    protected abstract void DecodeFromCBORObject(CBORObject var1) throws CoseException;

    protected abstract CBORObject EncodeCBORObject() throws CoseException;

    public CBORObject EncodeToCBORObject() throws CoseException {
        CBORObject obj = this.EncodeCBORObject();
        if (this.emitTag) {
            obj = CBORObject.FromObjectAndTag((Object)obj, (int)this.messageTag.value);
        }
        return obj;
    }

    public byte[] GetContent() {
        return this.rgbContent;
    }

    public boolean HasContent() {
        return this.rgbContent != null;
    }

    public void SetContent(byte[] rgbData) {
        this.rgbContent = rgbData;
    }

    public void SetContent(String strData) {
        this.rgbContent = strData.getBytes(StandardCharsets.UTF_8);
    }

    public void addCountersignature(CounterSign countersignature) {
        this.counterSignList.add(countersignature);
    }

    public List<CounterSign> getCountersignerList() {
        return this.counterSignList;
    }

    public CounterSign1 getCountersign1() {
        return this.counterSign1;
    }

    public void setCountersign1(CounterSign1 value) {
        this.counterSign1 = value;
    }

    protected void ProcessCounterSignatures() throws CoseException {
        if (!this.counterSignList.isEmpty()) {
            if (this.counterSignList.size() == 1) {
                this.counterSignList.get(0).sign(this.rgbProtected, this.rgbContent);
                this.addAttribute(HeaderKeys.CounterSignature, this.counterSignList.get(0).EncodeToCBORObject(), 2);
            } else {
                CBORObject list = CBORObject.NewArray();
                for (CounterSign sig : this.counterSignList) {
                    sig.sign(this.rgbProtected, this.rgbContent);
                    list.Add(sig.EncodeToCBORObject());
                }
                this.addAttribute(HeaderKeys.CounterSignature, list, 2);
            }
        }
        if (this.counterSign1 != null) {
            this.counterSign1.sign(this.rgbProtected, this.rgbContent);
            this.addAttribute(HeaderKeys.CounterSignature0, this.counterSign1.EncodeToCBORObject(), 2);
        }
    }

    public boolean validate(CounterSign1 countersignature) throws CoseException {
        return countersignature.validate(this.rgbProtected, this.rgbContent);
    }

    public boolean validate(CounterSign countersignature) throws CoseException {
        return countersignature.validate(this.rgbProtected, this.rgbContent);
    }
}

