/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10;

import com.google.common.collect.ObjectArrays;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.DataSet;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.bloodhound.Bloodhound;
import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.IKey;

public class TypeaheadConfig<T>
extends AbstractConfig {
    private static final long serialVersionUID = 1L;
    private final DataSet<T>[] datasets;
    private boolean selectEvent = false;
    private static final IKey<Boolean> Highlight = TypeaheadConfig.newKey((String)"highlight", (Object)Boolean.FALSE);
    private static final IKey<Boolean> Hint = TypeaheadConfig.newKey((String)"hint", (Object)Boolean.TRUE);
    private static final IKey<Integer> MinLength = TypeaheadConfig.newKey((String)"minLength", (Object)1);

    public TypeaheadConfig(DataSet<T> firstSet, DataSet<T> ... datasets) {
        if (firstSet == null || firstSet.getSource() == null) {
            throw new IllegalArgumentException("No valid dataset provided. You need to set a least one valid dataset.");
        }
        this.datasets = datasets != null ? (DataSet[])ObjectArrays.concat(firstSet, datasets) : new DataSet[]{firstSet};
    }

    public TypeaheadConfig<T> withHighlight(boolean highlight) {
        this.put(Highlight, highlight);
        return this;
    }

    public TypeaheadConfig<T> withHint(boolean hint) {
        this.put(Hint, hint);
        return this;
    }

    public TypeaheadConfig<T> withMinLength(int minLength) {
        this.put(MinLength, minLength);
        return this;
    }

    public TypeaheadConfig<T> withSelectEvent(boolean withSelectEvent) {
        this.selectEvent = withSelectEvent;
        return this;
    }

    public boolean isSelectEvent() {
        return this.selectEvent;
    }

    public DataSet<T>[] getDatasets() {
        return this.datasets;
    }

    public static <T> TypeaheadConfig<T> forRemote(Bloodhound<T> bloodhound) {
        return new TypeaheadConfig<T>(new DataSet<T>(bloodhound), new DataSet[0]);
    }
}

