/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.method;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.binding.method.InvalidMethodKeyException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class MethodKey
implements Serializable {
    private Class<?> declaredType;
    private String methodName;
    private Class<?>[] parameterTypes;
    private transient Method method;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_TYPE_MAP = new HashMap(8);

    public MethodKey(Class<?> declaredType, String methodName, Class<?> ... parameterTypes) {
        Assert.notNull(declaredType, (String)"The method's declared type is required");
        Assert.notNull((Object)methodName, (String)"The method name is required");
        this.declaredType = declaredType;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
    }

    public Class<?> getDeclaredType() {
        return this.declaredType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Method getMethod() throws InvalidMethodKeyException {
        if (this.method == null) {
            this.method = this.resolveMethod();
        }
        return this.method;
    }

    protected Method resolveMethod() throws InvalidMethodKeyException {
        try {
            return this.declaredType.getMethod(this.methodName, this.parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Method method = this.findMethodConsiderAssignableParameterTypes();
            if (method != null) {
                return method;
            }
            throw new InvalidMethodKeyException(this, e);
        }
    }

    protected Method findMethodConsiderAssignableParameterTypes() {
        Method[] candidateMethods;
        for (Method candidateMethod : candidateMethods = this.getDeclaredType().getMethods()) {
            Class<?>[] candidateParameterTypes;
            if (!candidateMethod.getName().equals(this.methodName) || (candidateParameterTypes = candidateMethod.getParameterTypes()).length != this.parameterTypes.length) continue;
            int numberOfCorrectArguments = 0;
            for (int j = 0; j < candidateParameterTypes.length; ++j) {
                Class<?> candidateType = candidateParameterTypes[j];
                Class<?> parameterType = this.parameterTypes[j];
                if (parameterType != null) {
                    if (!MethodKey.isAssignable(candidateType, parameterType)) continue;
                    ++numberOfCorrectArguments;
                    continue;
                }
                ++numberOfCorrectArguments;
            }
            if (numberOfCorrectArguments != this.parameterTypes.length) continue;
            return candidateMethod;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodKey)) {
            return false;
        }
        MethodKey other = (MethodKey)obj;
        return this.declaredType.equals(other.declaredType) && this.methodName.equals(other.methodName) && this.parameterTypesEqual(other.parameterTypes);
    }

    private boolean parameterTypesEqual(Class<?>[] other) {
        if (this.parameterTypes == other) {
            return true;
        }
        if (this.parameterTypes.length != other.length) {
            return false;
        }
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (ObjectUtils.nullSafeEquals(this.parameterTypes[i], other[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.declaredType.hashCode() + this.methodName.hashCode() + this.parameterTypesHash();
    }

    private int parameterTypesHash() {
        if (this.parameterTypes == null) {
            return 0;
        }
        int hash = 0;
        for (Class<?> parameterType : this.parameterTypes) {
            if (parameterType == null) continue;
            hash += parameterType.hashCode();
        }
        return hash;
    }

    public String toString() {
        return this.methodName + "(" + this.parameterTypesString() + ")";
    }

    private String parameterTypesString() {
        StringBuilder parameterTypesString = new StringBuilder();
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (this.parameterTypes[i] == null) {
                parameterTypesString.append("<any>");
            } else {
                parameterTypesString.append(ClassUtils.getShortName(this.parameterTypes[i]));
            }
            if (i >= this.parameterTypes.length - 1) continue;
            parameterTypesString.append(',');
        }
        return parameterTypesString.toString();
    }

    private static boolean isAssignable(Class<?> targetType, Class<?> valueType) {
        return targetType.isAssignableFrom(valueType) || targetType.equals(PRIMITIVE_WRAPPER_TYPE_MAP.get(valueType));
    }

    static {
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Boolean.class, Boolean.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Byte.class, Byte.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Character.class, Character.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Double.class, Double.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Float.class, Float.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Integer.class, Integer.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Long.class, Long.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Short.class, Short.TYPE);
    }
}

