/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.api.search;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchConditionVisitor;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.search.AbstractFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.search.SyncopeFiqlParser;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;

public final class SearchCondConverter {
    public static SearchCond convert(SearchCondVisitor visitor, String fiql, String ... realms) {
        SyncopeFiqlParser parser = new SyncopeFiqlParser(SearchBean.class, AbstractFiqlSearchConditionBuilder.CONTEXTUAL_PROPERTIES);
        try {
            if (realms != null && realms.length > 0) {
                visitor.setRealm(realms[0]);
            }
            SearchCondition sc = parser.parse(URLDecoder.decode(fiql, StandardCharsets.UTF_8));
            sc.accept((SearchConditionVisitor)visitor);
            return visitor.getQuery();
        }
        catch (Exception e) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSearchParameters);
            sce.getElements().add(fiql);
            sce.getElements().add(ExceptionUtils.getRootCauseMessage((Throwable)e));
            throw sce;
        }
    }

    private SearchCondConverter() {
    }
}

