/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job.notification;

import java.util.Optional;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.provisioning.api.job.JobDelegate;
import org.apache.syncope.core.provisioning.api.notification.NotificationJobDelegate;
import org.apache.syncope.core.provisioning.java.job.AbstractInterruptableJob;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationJob
extends AbstractInterruptableJob {
    protected static final Logger LOG = LoggerFactory.getLogger(NotificationJob.class);
    public static final String DEFAULT_CRON_EXP = "0 0/5 * * * ?";
    protected final SecurityProperties securityProperties;
    protected final DomainHolder domainHolder;
    protected final NotificationJobDelegate delegate;

    public NotificationJob(SecurityProperties securityProperties, DomainHolder domainHolder, NotificationJobDelegate delegate) {
        this.securityProperties = securityProperties;
        this.domainHolder = domainHolder;
        this.delegate = delegate;
    }

    @Override
    public JobDelegate getDelegate() {
        return this.delegate;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        LOG.debug("Waking up...");
        String executor = Optional.ofNullable(context.getMergedJobDataMap().getString("executor")).orElse(this.securityProperties.getAdminUser());
        for (String domain : this.domainHolder.getDomains().keySet()) {
            try {
                AuthContextUtils.callAsAdmin((String)domain, () -> {
                    try {
                        this.delegate.execute(executor);
                    }
                    catch (Exception e) {
                        LOG.error("While sending out notifications", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                    return null;
                });
            }
            catch (RuntimeException e) {
                LOG.error("While sending out notifications", (Throwable)e);
                throw new JobExecutionException("While sending out notifications", (Throwable)e);
            }
        }
        LOG.debug("Sleeping again...");
    }

    public static enum Status {
        SENT,
        NOT_SENT;

    }
}

