/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.dao.AllowedSchemas;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.GroupableRelatable;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.AnyCheck;
import org.apache.syncope.core.spring.ApplicationContextProvider;

public class AnyValidator
extends AbstractValidator<AnyCheck, Any> {
    private static boolean raiseNotAllowedViolation(ConstraintValidatorContext context, String schema, Group group) {
        if (group == null) {
            context.buildConstraintViolationWithTemplate(AnyValidator.getTemplate(EntityViolationType.InvalidPlainAttr, schema + " not allowed for this instance")).addPropertyNode("plainAttrs").addConstraintViolation();
        } else {
            context.buildConstraintViolationWithTemplate(AnyValidator.getTemplate(EntityViolationType.InvalidPlainAttr, schema + " not allowed for membership of group " + group.getName())).addPropertyNode("plainAttrs").addConstraintViolation();
        }
        return false;
    }

    public boolean isValid(Any any, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        AllowedSchemas allowedPlainSchemas = ((AnyUtilsFactory)ApplicationContextProvider.getApplicationContext().getBean(AnyUtilsFactory.class)).getInstance(any.getType().getKind()).dao().findAllowedSchemas(any, PlainSchema.class);
        for (PlainAttr attr : any.getPlainAttrs()) {
            if (attr == null || allowedPlainSchemas.forSelfContains(attr.getSchema().getKey())) continue;
            return AnyValidator.raiseNotAllowedViolation(context, attr.getSchema().getKey(), null);
        }
        if (any instanceof GroupableRelatable) {
            for (Membership membership : ((GroupableRelatable)any).getMemberships()) {
                for (PlainAttr attr : ((GroupableRelatable)any).getPlainAttrs(membership)) {
                    if (attr == null || allowedPlainSchemas.forMembershipsContains((Group)membership.getRightEnd(), attr.getSchema().getKey())) continue;
                    return AnyValidator.raiseNotAllowedViolation(context, attr.getSchema().getKey(), (Group)membership.getRightEnd());
                }
            }
        }
        return true;
    }
}

