/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.measure.Unit;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.CategoryList;
import org.apache.sis.coverage.SampleRangeFormat;
import org.apache.sis.coverage.ToNaN;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.transform.TransferFunction;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.internal.UnmodifiableArrayList;
import org.apache.sis.util.iso.Names;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class SampleDimension
implements Serializable {
    private static final long serialVersionUID = -4966135180995819364L;
    private final GenericName name;
    private final Number background;
    private final CategoryList categories;
    private final MathTransform1D transferFunction;
    private final SampleDimension converse;

    private SampleDimension(SampleDimension original, Category bc) {
        this.converse = original;
        this.name = original.name;
        this.categories = original.categories.converse;
        this.transferFunction = Category.identity();
        this.background = bc != null ? (Number)((Number)bc.converse.range.getMinValue()) : (Number)null;
    }

    public SampleDimension(GenericName name, Number background, Collection<? extends Category> categories) {
        ArgumentChecks.ensureNonNull("name", name);
        ArgumentChecks.ensureNonNull("categories", categories);
        CategoryList list = categories.isEmpty() ? CategoryList.EMPTY : CategoryList.create((Category[])categories.toArray(Category[]::new), background);
        this.name = name;
        this.background = background;
        this.categories = list;
        if (list.converse.range == null) {
            this.transferFunction = null;
            this.converse = null;
        } else if (list == list.converse) {
            this.transferFunction = Category.identity();
            this.converse = this;
        } else {
            assert (!list.isEmpty());
            this.transferFunction = list.getTransferFunction();
            this.converse = new SampleDimension(this, background != null ? list.search(background.doubleValue()) : null);
        }
    }

    private SampleDimension converted() {
        return this.converse != null && !this.transferFunction.isIdentity() ? this.converse : this;
    }

    public GenericName getName() {
        return this.name;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public Optional<Number> getBackground() {
        return Optional.ofNullable(this.background);
    }

    public Set<Number> getNoDataValues() {
        if (this.converse != null) {
            boolean isConverted = this.transferFunction.isIdentity();
            NumberRange[] ranges = new NumberRange[this.categories.size()];
            Class widestClass = Byte.class;
            int count = 0;
            for (Category category : this.categories) {
                Category converted = category.converted();
                if (!isConverted && category == converted || !converted.isConvertedQualitative()) continue;
                NumberRange<?> range = category.range;
                if (!range.isBounded()) {
                    throw new IllegalStateException(Resources.format((short)6, range));
                }
                widestClass = Numbers.widestClass(widestClass, range.getElementType());
                ranges[count++] = range;
            }
            if (count != 0) {
                TreeSet<Number> noDataValues = new TreeSet<Number>(SampleDimension::compare);
                for (int i = 0; i < count; ++i) {
                    NumberRange range = ranges[i];
                    Number minimum = (Number)range.getMinValue();
                    Number maximum = (Number)range.getMaxValue();
                    if (range.isMinIncluded()) {
                        noDataValues.add(Numbers.cast(minimum, widestClass));
                    }
                    if (range.isMaxIncluded()) {
                        noDataValues.add(Numbers.cast(maximum, widestClass));
                    }
                    if (Numbers.isInteger(range.getElementType())) {
                        long value = minimum.longValue() + 1L;
                        long stop = maximum.longValue() - 1L;
                        while (value <= stop) {
                            noDataValues.add(Numbers.wrap(value, widestClass));
                        }
                        continue;
                    }
                    if (minimum.equals(maximum)) continue;
                    throw new IllegalStateException(Resources.format((short)6, range));
                }
                return noDataValues;
            }
        }
        return Collections.emptySet();
    }

    private static int compare(Number n1, Number n2) {
        return Category.compare(n1.doubleValue(), n2.doubleValue());
    }

    public Optional<NumberRange<?>> getSampleRange() {
        return Optional.ofNullable(this.categories.range);
    }

    public Optional<MeasurementRange<?>> getMeasurementRange() {
        if (this.converse == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((MeasurementRange)this.converted().categories.range);
    }

    public Optional<MathTransform1D> getTransferFunction() {
        return Optional.ofNullable(this.transferFunction);
    }

    public Optional<TransferFunction> getTransferFunctionFormula() {
        MathTransform1D tr = null;
        for (Category category : this.categories) {
            Optional<MathTransform1D> c = category.getTransferFunction();
            if (!c.isPresent()) continue;
            if (tr == null) {
                tr = c.get();
                continue;
            }
            if (tr.equals(c.get())) continue;
            throw new IllegalStateException(Resources.format((short)13));
        }
        if (tr == null) {
            return Optional.empty();
        }
        TransferFunction f = new TransferFunction();
        try {
            f.setTransform(tr);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(Resources.format((short)13, e));
        }
        return Optional.of(f);
    }

    public Optional<Unit<?>> getUnits() {
        Unit<?> unit = null;
        for (Category category : this.converted().categories) {
            Unit<?> c;
            NumberRange<?> r = category.range;
            if (!(r instanceof MeasurementRange) || (c = ((MeasurementRange)r).unit()) == null) continue;
            if (unit == null) {
                unit = c;
                continue;
            }
            if (unit.equals(c)) continue;
            throw new IllegalStateException();
        }
        return Optional.ofNullable(unit);
    }

    public boolean allowsNaN() {
        return this.categories.allowsNaN();
    }

    public SampleDimension forConvertedValues(boolean converted) {
        if (this.converse != null && this.transferFunction.isIdentity() != converted) {
            return this.converse;
        }
        return this;
    }

    public int hashCode() {
        return this.categories.hashCode() + 31 * this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SampleDimension) {
            SampleDimension that = (SampleDimension)object;
            return this.name.equals(that.name) && Objects.equals(this.background, that.background) && this.categories.equals(that.categories);
        }
        return false;
    }

    public String toString() {
        return new SampleRangeFormat(Locale.getDefault()).write(new SampleDimension[]{this});
    }

    public static String toString(Locale locale, SampleDimension ... dimensions) {
        ArgumentChecks.ensureNonNull("dimensions", dimensions);
        return new SampleRangeFormat(locale).write(dimensions);
    }

    public static class Builder {
        private static final InternationalString DATA = Vocabulary.formatInternational((short)47);
        private static final InternationalString NODATA = Vocabulary.formatInternational((short)140);
        private static final InternationalString FILL_VALUE = Vocabulary.formatInternational((short)83);
        private GenericName dimensionName;
        private Category[] categories = new Category[10];
        private int count;
        private final ToNaN toNaN = new ToNaN();

        public GenericName getName() {
            return this.dimensionName;
        }

        public Builder setName(GenericName name) {
            this.dimensionName = name;
            return this;
        }

        public Builder setName(CharSequence name) {
            return this.setName(Builder.createLocalName(name));
        }

        public Builder setName(int band) {
            return this.setName(Names.createMemberName(null, null, band));
        }

        private static GenericName createLocalName(CharSequence name) {
            return Names.createLocalName(null, null, name);
        }

        private static NumberRange<?> range(Class<?> type, Number minimum, Number maximum) {
            switch (Numbers.getEnumConstant(type)) {
                case 3: {
                    return NumberRange.create(minimum.byteValue(), true, maximum.byteValue(), true);
                }
                case 4: {
                    return NumberRange.create(minimum.shortValue(), true, maximum.shortValue(), true);
                }
                case 5: {
                    return NumberRange.create(minimum.intValue(), true, maximum.intValue(), true);
                }
                case 6: {
                    return NumberRange.create(minimum.longValue(), true, maximum.longValue(), true);
                }
                case 8: {
                    float min = minimum.floatValue();
                    float max = maximum.floatValue();
                    if (!Float.isNaN(min) || !Float.isNaN(max)) {
                        return NumberRange.create(min, true, max, true);
                    }
                    if (minimum.getClass() != Float.class) {
                        minimum = Float.valueOf(min);
                    }
                    if (maximum.getClass() == Float.class) break;
                    maximum = Float.valueOf(max);
                    break;
                }
                default: {
                    double min = minimum.doubleValue();
                    double max = maximum.doubleValue();
                    if (!Double.isNaN(min) || !Double.isNaN(max)) {
                        return NumberRange.create(min, true, max, true);
                    }
                    if (minimum.getClass() != Double.class) {
                        minimum = min;
                    }
                    if (maximum.getClass() == Double.class) break;
                    maximum = max;
                    break;
                }
            }
            NumberRange<Number> samples = new NumberRange<Number>(type, minimum, true, maximum, true);
            return samples;
        }

        public Number getBackground() {
            return this.toNaN.background;
        }

        public Builder setBackground(Number sample) {
            this.toNaN.background = sample;
            return this;
        }

        public Builder setBackground(CharSequence name, Number sample) {
            ArgumentChecks.ensureNonNull("sample", sample);
            if (name == null) {
                name = FILL_VALUE;
            }
            NumberRange<?> samples = Builder.range(sample.getClass(), sample, sample);
            this.toNaN.background = (Number)samples.getMinValue();
            this.add(new Category(name, samples, null, null, this.toNaN));
            return this;
        }

        public Builder addQualitative(CharSequence name, boolean sample) {
            byte value = sample ? (byte)1 : 0;
            return this.addQualitative(name, NumberRange.create(value, true, value, true));
        }

        public Builder addQualitative(CharSequence name, byte sample) {
            return this.addQualitative(name, NumberRange.create(sample, true, sample, true));
        }

        public Builder addQualitative(CharSequence name, short sample) {
            return this.addQualitative(name, NumberRange.create(sample, true, sample, true));
        }

        public Builder addQualitative(CharSequence name, int sample) {
            return this.addQualitative(name, NumberRange.create(sample, true, sample, true));
        }

        public Builder addQualitative(CharSequence name, float sample) {
            NumberRange<Float> range;
            if (Float.isNaN(sample)) {
                Float wrapper = Float.valueOf(sample);
                range = new NumberRange<Float>(Float.class, wrapper, true, wrapper, true);
            } else {
                range = NumberRange.create(sample, true, sample, true);
            }
            return this.addQualitative(name, range);
        }

        public Builder addQualitative(CharSequence name, double sample) {
            NumberRange<Double> range;
            if (Double.isNaN(sample)) {
                Double wrapper = sample;
                range = new NumberRange<Double>(Double.class, wrapper, true, wrapper, true);
            } else {
                range = NumberRange.create(sample, true, sample, true);
            }
            return this.addQualitative(name, range);
        }

        public Builder addQualitative(CharSequence name, Number minimum, Number maximum) {
            ArgumentChecks.ensureNonNull("minimum", minimum);
            ArgumentChecks.ensureNonNull("maximum", maximum);
            return this.addQualitative(name, Builder.range(Numbers.widestClass(minimum, maximum), minimum, maximum));
        }

        public Builder addQualitative(CharSequence name, NumberRange<?> samples) {
            if (name == null) {
                name = NODATA;
            }
            this.add(new Category(name, samples, null, null, this.toNaN));
            return this;
        }

        public Builder mapQualitative(CharSequence name, Number sample, float converted) {
            ArgumentChecks.ensureNonNull("sample", sample);
            return this.mapQualitative(name, Builder.range(sample.getClass(), sample, sample), converted);
        }

        public Builder mapQualitative(CharSequence name, NumberRange<?> samples, float converted) {
            ArgumentChecks.ensureNonEmpty("samples", samples);
            int ordinal = MathFunctions.toNanOrdinal(converted);
            if (!this.toNaN.add(ordinal)) {
                throw new IllegalArgumentException(Errors.format((short)164, "NaN #" + ordinal));
            }
            if (name == null) {
                name = NODATA;
            }
            this.add(new Category(name, samples, null, null, v -> ordinal));
            return this;
        }

        public Builder addQuantitative(CharSequence name, NumberRange<?> samples, NumberRange<?> converted) {
            ArgumentChecks.ensureNonEmpty("samples", samples);
            ArgumentChecks.ensureNonEmpty("converted", converted);
            boolean isMinIncluded = samples.isMinIncluded();
            boolean isMaxIncluded = samples.isMaxIncluded() && samples.getSpan() > 0.0;
            double minValue = converted.getMinDouble(isMinIncluded);
            double \u0394value = converted.getMaxDouble(isMaxIncluded) - minValue;
            double minSample = samples.getMinDouble(isMinIncluded);
            double \u0394sample = samples.getMaxDouble(isMaxIncluded) - minSample;
            double scale = \u0394value != 0.0 ? \u0394value / \u0394sample : 1.0;
            TransferFunction transferFunction = new TransferFunction();
            transferFunction.setScale(scale);
            transferFunction.setOffset(Math.fma(-scale, minSample, minValue));
            return this.addQuantitative(name, samples, transferFunction.getTransform(), converted instanceof MeasurementRange ? ((MeasurementRange)converted).unit() : null);
        }

        public Builder addQuantitative(CharSequence name, float minimum, float maximum, Unit<?> units) {
            return this.addQuantitative(name, MeasurementRange.create(minimum, true, maximum, true, units), Category.identity(), units);
        }

        public Builder addQuantitative(CharSequence name, double minimum, double maximum, Unit<?> units) {
            return this.addQuantitative(name, MeasurementRange.create(minimum, true, maximum, true, units), Category.identity(), units);
        }

        public Builder addQuantitative(CharSequence name, int lower, int upper, double scale, double offset, Unit<?> units) {
            TransferFunction transferFunction = new TransferFunction();
            transferFunction.setScale(scale);
            transferFunction.setOffset(offset);
            return this.addQuantitative(name, NumberRange.create(lower, true, upper, false), transferFunction.getTransform(), units);
        }

        public Builder addQuantitative(CharSequence name, NumberRange<?> samples, MathTransform1D toUnits, Unit<?> units) {
            ArgumentChecks.ensureNonNull("toUnits", toUnits);
            if (name == null) {
                name = DATA;
            }
            this.add(new Category(name, samples, toUnits, units, this.toNaN));
            return this;
        }

        private void add(Category category) {
            if (this.count == this.categories.length) {
                this.categories = Arrays.copyOf(this.categories, this.count * 2);
            }
            this.categories[this.count++] = category;
        }

        public List<Category> categories() {
            return new AbstractList<Category>(){

                @Override
                public int size() {
                    return count;
                }

                @Override
                public Category get(int i) {
                    ArgumentChecks.ensureValidIndex(count, i);
                    return categories[i];
                }

                @Override
                public Category remove(int i) {
                    ArgumentChecks.ensureValidIndex(count, i);
                    Category c = categories[i];
                    System.arraycopy(categories, i + 1, categories, i, --count - i);
                    categories[count] = null;
                    toNaN.remove(c);
                    return c;
                }

                @Override
                protected void removeRange(int fromIndex, int toIndex) {
                    System.arraycopy(categories, toIndex, categories, fromIndex, count - toIndex);
                    Arrays.fill(categories, toIndex, count, null);
                    count -= toIndex - fromIndex;
                }
            };
        }

        public SampleDimension build() {
            GenericName name;
            block2: {
                name = this.dimensionName;
                if (name == null) {
                    for (int i = 0; i < this.count; ++i) {
                        if (!this.categories[i].isQuantitative()) continue;
                        name = Builder.createLocalName(this.categories[i].name);
                        break block2;
                    }
                    name = Builder.createLocalName(Vocabulary.formatInternational((short)210));
                }
            }
            return new SampleDimension(name, this.toNaN.background, UnmodifiableArrayList.wrap(this.categories, 0, this.count));
        }

        public void clear() {
            this.dimensionName = null;
            this.count = 0;
            Arrays.fill(this.categories, null);
            this.toNaN.clear();
        }
    }
}

