/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pkix.jcajce;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.qualified.Iso4217CurrencyCode;
import org.bouncycastle.asn1.x509.qualified.MonetaryValue;
import org.bouncycastle.asn1.x509.qualified.QCStatement;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.pkix.PKIXNameConstraintValidator;
import org.bouncycastle.pkix.PKIXNameConstraintValidatorException;
import org.bouncycastle.pkix.jcajce.AnnotatedException;
import org.bouncycastle.pkix.jcajce.CertPathReviewerException;
import org.bouncycastle.pkix.jcajce.CertPathValidatorUtilities;
import org.bouncycastle.pkix.jcajce.PKIXCRLUtil;
import org.bouncycastle.pkix.jcajce.PKIXPolicyNode;
import org.bouncycastle.pkix.jcajce.X509CRLStoreSelector;
import org.bouncycastle.pkix.util.ErrorBundle;
import org.bouncycastle.pkix.util.LocaleString;
import org.bouncycastle.pkix.util.filter.TrustedInput;
import org.bouncycastle.pkix.util.filter.UntrustedInput;
import org.bouncycastle.pkix.util.filter.UntrustedUrlInput;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Objects;

public class PKIXCertPathReviewer
extends CertPathValidatorUtilities {
    private static final String QC_STATEMENT = Extension.qCStatements.getId();
    private static final String CRL_DIST_POINTS = Extension.cRLDistributionPoints.getId();
    private static final String AUTH_INFO_ACCESS = Extension.authorityInfoAccess.getId();
    private static final String RESOURCE_NAME = "org.bouncycastle.pkix.CertPathReviewerMessages";
    private static final int NAME_CHECK_MAX = 1024;
    protected CertPath certPath;
    protected PKIXParameters pkixParams;
    protected Date currentDate;
    protected Date validDate;
    protected List certs;
    protected int n;
    protected List[] notifications;
    protected List[] errors;
    protected TrustAnchor trustAnchor;
    protected PublicKey subjectPublicKey;
    protected PolicyNode policyTree;
    private boolean initialized;

    public void init(CertPath certPath, PKIXParameters pKIXParameters) throws CertPathReviewerException {
        if (this.initialized) {
            throw new IllegalStateException("object is already initialized!");
        }
        this.initialized = true;
        if (certPath == null) {
            throw new NullPointerException("certPath was null");
        }
        List<? extends Certificate> list = certPath.getCertificates();
        if (list.size() != 1) {
            HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
            for (TrustAnchor trustAnchor : pKIXParameters.getTrustAnchors()) {
                hashSet.add(trustAnchor.getTrustedCert());
            }
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i != list.size(); ++i) {
                if (hashSet.contains(list.get(i))) continue;
                arrayList.add(list.get(i));
            }
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
                this.certPath = certificateFactory.generateCertPath(arrayList);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IllegalStateException("unable to rebuild certpath");
            }
            this.certs = arrayList;
        } else {
            this.certPath = certPath;
            this.certs = certPath.getCertificates();
        }
        this.n = this.certs.size();
        if (this.certs.isEmpty()) {
            throw new CertPathReviewerException(PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.emptyCertPath"));
        }
        this.pkixParams = (PKIXParameters)pKIXParameters.clone();
        this.currentDate = new Date();
        this.validDate = PKIXCertPathReviewer.getValidityDate(this.pkixParams, this.currentDate);
        this.notifications = null;
        this.errors = null;
        this.trustAnchor = null;
        this.subjectPublicKey = null;
        this.policyTree = null;
    }

    public PKIXCertPathReviewer(CertPath certPath, PKIXParameters pKIXParameters) throws CertPathReviewerException {
        this.init(certPath, pKIXParameters);
    }

    public PKIXCertPathReviewer() {
    }

    public CertPath getCertPath() {
        return this.certPath;
    }

    public int getCertPathSize() {
        return this.n;
    }

    public List[] getErrors() {
        this.doChecks();
        return this.errors;
    }

    public List getErrors(int n) {
        this.doChecks();
        return this.errors[n + 1];
    }

    public List[] getNotifications() {
        this.doChecks();
        return this.notifications;
    }

    public List getNotifications(int n) {
        this.doChecks();
        return this.notifications[n + 1];
    }

    public PolicyNode getPolicyTree() {
        this.doChecks();
        return this.policyTree;
    }

    public PublicKey getSubjectPublicKey() {
        this.doChecks();
        return this.subjectPublicKey;
    }

    public TrustAnchor getTrustAnchor() {
        this.doChecks();
        return this.trustAnchor;
    }

    public boolean isValidCertPath() {
        this.doChecks();
        boolean bl = true;
        for (int i = 0; i < this.errors.length; ++i) {
            if (this.errors[i].isEmpty()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    protected void addNotification(ErrorBundle errorBundle) {
        this.notifications[0].add(errorBundle);
    }

    protected void addNotification(ErrorBundle errorBundle, int n) {
        if (n < -1 || n >= this.n) {
            throw new IndexOutOfBoundsException();
        }
        this.notifications[n + 1].add(errorBundle);
    }

    protected void addError(ErrorBundle errorBundle) {
        this.errors[0].add(errorBundle);
    }

    protected void addError(ErrorBundle errorBundle, int n) {
        if (n < -1 || n >= this.n) {
            throw new IndexOutOfBoundsException();
        }
        this.errors[n + 1].add(errorBundle);
    }

    protected void doChecks() {
        if (!this.initialized) {
            throw new IllegalStateException("Object not initialized. Call init() first.");
        }
        if (this.notifications == null) {
            this.notifications = new List[this.n + 1];
            this.errors = new List[this.n + 1];
            for (int i = 0; i < this.notifications.length; ++i) {
                this.notifications[i] = new ArrayList();
                this.errors[i] = new ArrayList();
            }
            this.checkSignatures();
            this.checkNameConstraints();
            this.checkPathLength();
            this.checkPolicy();
            this.checkCriticalExtensions();
        }
    }

    private void checkNameConstraints() {
        X509Certificate x509Certificate = null;
        PKIXNameConstraintValidator pKIXNameConstraintValidator = new PKIXNameConstraintValidator();
        try {
            for (int i = this.certs.size() - 1; i > 0; --i) {
                int n;
                ASN1Sequence aSN1Sequence;
                ASN1Sequence aSN1Sequence2;
                ASN1InputStream aSN1InputStream;
                X500Principal x500Principal;
                int n2 = this.n - i;
                x509Certificate = (X509Certificate)this.certs.get(i);
                if (!PKIXCertPathReviewer.isSelfIssued(x509Certificate)) {
                    ErrorBundle errorBundle;
                    x500Principal = PKIXCertPathReviewer.getSubjectPrincipal(x509Certificate);
                    aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(x500Principal.getEncoded()));
                    try {
                        aSN1Sequence2 = (ASN1Sequence)aSN1InputStream.readObject();
                    }
                    catch (IOException iOException) {
                        ErrorBundle errorBundle2 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.ncSubjectNameError", new Object[]{new UntrustedInput(x500Principal)});
                        throw new CertPathReviewerException(errorBundle2, (Throwable)iOException, this.certPath, i);
                    }
                    try {
                        pKIXNameConstraintValidator.checkPermittedDN(aSN1Sequence2);
                    }
                    catch (PKIXNameConstraintValidatorException pKIXNameConstraintValidatorException) {
                        ErrorBundle errorBundle3 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.notPermittedDN", new Object[]{new UntrustedInput(x500Principal.getName())});
                        throw new CertPathReviewerException(errorBundle3, (Throwable)pKIXNameConstraintValidatorException, this.certPath, i);
                    }
                    try {
                        pKIXNameConstraintValidator.checkExcludedDN(aSN1Sequence2);
                    }
                    catch (PKIXNameConstraintValidatorException pKIXNameConstraintValidatorException) {
                        ErrorBundle errorBundle4 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.excludedDN", new Object[]{new UntrustedInput(x500Principal.getName())});
                        throw new CertPathReviewerException(errorBundle4, (Throwable)pKIXNameConstraintValidatorException, this.certPath, i);
                    }
                    try {
                        aSN1Sequence = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, SUBJECT_ALTERNATIVE_NAME);
                    }
                    catch (AnnotatedException annotatedException) {
                        errorBundle = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.subjAltNameExtError");
                        throw new CertPathReviewerException(errorBundle, (Throwable)annotatedException, this.certPath, i);
                    }
                    if (aSN1Sequence != null) {
                        if (aSN1Sequence.size() > 1024) {
                            ErrorBundle errorBundle5 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.subjAltNameExtError");
                            throw new CertPathReviewerException(errorBundle5, this.certPath, i);
                        }
                        for (n = 0; n < aSN1Sequence.size(); ++n) {
                            errorBundle = GeneralName.getInstance((Object)aSN1Sequence.getObjectAt(n));
                            try {
                                pKIXNameConstraintValidator.checkPermitted((GeneralName)errorBundle);
                                pKIXNameConstraintValidator.checkExcluded((GeneralName)errorBundle);
                                continue;
                            }
                            catch (PKIXNameConstraintValidatorException pKIXNameConstraintValidatorException) {
                                ErrorBundle errorBundle6 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.notPermittedEmail", new Object[]{new UntrustedInput(errorBundle)});
                                throw new CertPathReviewerException(errorBundle6, (Throwable)pKIXNameConstraintValidatorException, this.certPath, i);
                            }
                        }
                    }
                }
                try {
                    x500Principal = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, NAME_CONSTRAINTS);
                }
                catch (AnnotatedException annotatedException) {
                    aSN1Sequence2 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.ncExtError");
                    throw new CertPathReviewerException((ErrorBundle)aSN1Sequence2, (Throwable)annotatedException, this.certPath, i);
                }
                if (x500Principal == null) continue;
                aSN1InputStream = NameConstraints.getInstance((Object)x500Principal);
                aSN1Sequence2 = aSN1InputStream.getPermittedSubtrees();
                if (aSN1Sequence2 != null) {
                    pKIXNameConstraintValidator.intersectPermittedSubtree((GeneralSubtree[])aSN1Sequence2);
                }
                if ((aSN1Sequence = aSN1InputStream.getExcludedSubtrees()) == null) continue;
                for (n = 0; n != ((GeneralSubtree[])aSN1Sequence).length; ++n) {
                    pKIXNameConstraintValidator.addExcludedSubtree(aSN1Sequence[n]);
                }
            }
        }
        catch (CertPathReviewerException certPathReviewerException) {
            this.addError(certPathReviewerException.getErrorMessage(), certPathReviewerException.getIndex());
        }
    }

    private void checkPathLength() {
        int n = this.n;
        int n2 = 0;
        X509Certificate x509Certificate = null;
        for (int i = this.certs.size() - 1; i > 0; --i) {
            ASN1Integer aSN1Integer;
            ErrorBundle errorBundle;
            int n3 = this.n - i;
            x509Certificate = (X509Certificate)this.certs.get(i);
            if (!PKIXCertPathReviewer.isSelfIssued(x509Certificate)) {
                if (n <= 0) {
                    errorBundle = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.pathLengthExtended");
                    this.addError(errorBundle);
                }
                --n;
                ++n2;
            }
            try {
                errorBundle = BasicConstraints.getInstance((Object)PKIXCertPathReviewer.getExtensionValue(x509Certificate, BASIC_CONSTRAINTS));
            }
            catch (AnnotatedException annotatedException) {
                ErrorBundle errorBundle2 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.processLengthConstError");
                this.addError(errorBundle2, i);
                errorBundle = null;
            }
            if (errorBundle == null || !errorBundle.isCA() || (aSN1Integer = errorBundle.getPathLenConstraintInteger()) == null) continue;
            n = Math.min(n, aSN1Integer.intPositiveValueExact());
        }
        ErrorBundle errorBundle = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.totalPathLength", new Object[]{Integers.valueOf((int)n2)});
        this.addNotification(errorBundle);
    }

    private void checkSignatures() {
        Object object;
        Object object2;
        Object object3;
        TrustAnchor trustAnchor = null;
        Object object4 = null;
        Object object5 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.certPathValidDate", new Object[]{new TrustedInput(this.validDate), new TrustedInput(this.currentDate)});
        this.addNotification((ErrorBundle)object5);
        try {
            object5 = (X509Certificate)this.certs.get(this.certs.size() - 1);
            object3 = this.getTrustAnchors((X509Certificate)object5, this.pkixParams.getTrustAnchors());
            if (object3.size() > 1) {
                object2 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.conflictingTrustAnchors", new Object[]{Integers.valueOf((int)object3.size()), new UntrustedInput(((X509Certificate)object5).getIssuerX500Principal())});
                this.addError((ErrorBundle)object2);
            } else if (object3.isEmpty()) {
                object2 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.noTrustAnchorFound", new Object[]{new UntrustedInput(((X509Certificate)object5).getIssuerX500Principal()), Integers.valueOf((int)this.pkixParams.getTrustAnchors().size())});
                this.addError((ErrorBundle)object2);
            } else {
                trustAnchor = (TrustAnchor)object3.iterator().next();
                object2 = trustAnchor.getTrustedCert() != null ? trustAnchor.getTrustedCert().getPublicKey() : trustAnchor.getCAPublicKey();
                try {
                    CertPathValidatorUtilities.verifyX509Certificate((X509Certificate)object5, (PublicKey)object2, this.pkixParams.getSigProvider());
                }
                catch (SignatureException signatureException) {
                    object = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.trustButInvalidCert");
                    this.addError((ErrorBundle)object);
                }
                catch (Exception exception) {}
            }
        }
        catch (CertPathReviewerException certPathReviewerException) {
            this.addError(certPathReviewerException.getErrorMessage());
        }
        catch (Throwable throwable) {
            object3 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.unknown", new Object[]{new UntrustedInput(throwable.getMessage()), new UntrustedInput(throwable)});
            this.addError((ErrorBundle)object3);
        }
        if (trustAnchor != null) {
            object5 = trustAnchor.getTrustedCert();
            try {
                object4 = object5 != null ? PKIXCertPathReviewer.getSubjectPrincipal((X509Certificate)object5) : new X500Principal(trustAnchor.getCAName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                object2 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.trustDNInvalid", new Object[]{new UntrustedInput(trustAnchor.getCAName())});
                this.addError((ErrorBundle)object2);
            }
            if (object5 != null && (object3 = (Object)((X509Certificate)object5).getKeyUsage()) != null && (((Object)object3).length <= 5 || object3[5] == false)) {
                object2 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.trustKeyUsage");
                this.addNotification((ErrorBundle)object2);
            }
        }
        object5 = null;
        object3 = object4;
        object2 = null;
        AlgorithmIdentifier algorithmIdentifier = null;
        object = null;
        ASN1Encodable aSN1Encodable = null;
        if (trustAnchor != null) {
            object2 = trustAnchor.getTrustedCert();
            object5 = object2 != null ? ((Certificate)object2).getPublicKey() : trustAnchor.getCAPublicKey();
            try {
                algorithmIdentifier = PKIXCertPathReviewer.getAlgorithmIdentifier((PublicKey)object5);
                object = algorithmIdentifier.getAlgorithm();
                aSN1Encodable = algorithmIdentifier.getParameters();
            }
            catch (CertPathValidatorException certPathValidatorException) {
                ErrorBundle errorBundle = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.trustPubKeyError");
                this.addError(errorBundle);
                algorithmIdentifier = null;
            }
        }
        X509Certificate x509Certificate = null;
        for (int i = this.certs.size() - 1; i >= 0; --i) {
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            ErrorBundle errorBundle;
            Object object10;
            int n = this.n - i;
            x509Certificate = (X509Certificate)this.certs.get(i);
            if (object5 != null) {
                try {
                    CertPathValidatorUtilities.verifyX509Certificate(x509Certificate, (PublicKey)object5, this.pkixParams.getSigProvider());
                }
                catch (GeneralSecurityException generalSecurityException) {
                    object10 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.signatureNotVerified", new Object[]{generalSecurityException.getMessage(), generalSecurityException, generalSecurityException.getClass().getName()});
                    this.addError((ErrorBundle)object10, i);
                }
            } else if (PKIXCertPathReviewer.isSelfIssued(x509Certificate)) {
                try {
                    CertPathValidatorUtilities.verifyX509Certificate(x509Certificate, x509Certificate.getPublicKey(), this.pkixParams.getSigProvider());
                    errorBundle = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.rootKeyIsValidButNotATrustAnchor");
                    this.addError(errorBundle, i);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    object10 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.signatureNotVerified", new Object[]{generalSecurityException.getMessage(), generalSecurityException, generalSecurityException.getClass().getName()});
                    this.addError((ErrorBundle)object10, i);
                }
            } else {
                errorBundle = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.NoIssuerPublicKey");
                object10 = x509Certificate.getExtensionValue(Extension.authorityKeyIdentifier.getId());
                if (object10 != null && (object9 = (object8 = AuthorityKeyIdentifier.getInstance((Object)ASN1OctetString.getInstance((Object)object10).getOctets())).getAuthorityCertIssuer()) != null) {
                    object7 = object9.getNames()[0];
                    object6 = object8.getAuthorityCertSerialNumber();
                    if (object6 != null) {
                        Object[] objectArray = new Object[]{new LocaleString(RESOURCE_NAME, "missingIssuer"), " \"", object7, "\" ", new LocaleString(RESOURCE_NAME, "missingSerial"), " ", object6};
                        errorBundle.setExtraArguments(objectArray);
                    }
                }
                this.addError(errorBundle, i);
            }
            try {
                x509Certificate.checkValidity(this.validDate);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                object10 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.certificateNotYetValid", new Object[]{new TrustedInput(x509Certificate.getNotBefore())});
                this.addError((ErrorBundle)object10, i);
            }
            catch (CertificateExpiredException certificateExpiredException) {
                object10 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.certificateExpired", new Object[]{new TrustedInput(x509Certificate.getNotAfter())});
                this.addError((ErrorBundle)object10, i);
            }
            if (this.pkixParams.isRevocationEnabled()) {
                errorBundle = null;
                try {
                    object10 = PKIXCertPathReviewer.getExtensionValue(x509Certificate, CRL_DIST_POINTS);
                    if (object10 != null) {
                        errorBundle = CRLDistPoint.getInstance((Object)object10);
                    }
                }
                catch (AnnotatedException annotatedException) {
                    object8 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.crlDistPtExtError");
                    this.addError((ErrorBundle)object8, i);
                }
                object10 = null;
                try {
                    object8 = PKIXCertPathReviewer.getExtensionValue(x509Certificate, AUTH_INFO_ACCESS);
                    if (object8 != null) {
                        object10 = AuthorityInformationAccess.getInstance((Object)object8);
                    }
                }
                catch (AnnotatedException annotatedException) {
                    object9 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.crlAuthInfoAccError");
                    this.addError((ErrorBundle)object9, i);
                }
                object8 = this.getCRLDistUrls((CRLDistPoint)errorBundle);
                object9 = this.getOCSPUrls((AuthorityInformationAccess)object10);
                object7 = ((Vector)object8).iterator();
                while (object7.hasNext()) {
                    object6 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.crlDistPoint", new Object[]{new UntrustedUrlInput(object7.next())});
                    this.addNotification((ErrorBundle)object6, i);
                }
                object7 = ((Vector)object9).iterator();
                while (object7.hasNext()) {
                    object6 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.ocspLocation", new Object[]{new UntrustedUrlInput(object7.next())});
                    this.addNotification((ErrorBundle)object6, i);
                }
                try {
                    this.checkRevocation(this.pkixParams, x509Certificate, this.validDate, (X509Certificate)object2, (PublicKey)object5, (Vector)object8, (Vector)object9, i);
                }
                catch (CertPathReviewerException certPathReviewerException) {
                    this.addError(certPathReviewerException.getErrorMessage(), i);
                }
            }
            if (object3 != null && !x509Certificate.getIssuerX500Principal().equals(object3)) {
                errorBundle = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.certWrongIssuer", new Object[]{((X500Principal)object3).getName(), x509Certificate.getIssuerX500Principal().getName()});
                this.addError(errorBundle, i);
            }
            if (n != this.n) {
                if (x509Certificate != null && x509Certificate.getVersion() == 1) {
                    errorBundle = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.noCACert");
                    this.addError(errorBundle, i);
                }
                try {
                    errorBundle = BasicConstraints.getInstance((Object)PKIXCertPathReviewer.getExtensionValue(x509Certificate, BASIC_CONSTRAINTS));
                    if (errorBundle != null) {
                        if (!errorBundle.isCA()) {
                            object10 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.noCACert");
                            this.addError((ErrorBundle)object10, i);
                        }
                    } else {
                        object10 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.noBasicConstraints");
                        this.addError((ErrorBundle)object10, i);
                    }
                }
                catch (AnnotatedException annotatedException) {
                    object8 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.errorProcesingBC");
                    this.addError((ErrorBundle)object8, i);
                }
                object10 = x509Certificate.getKeyUsage();
                if (object10 != null && (((byte[])object10).length <= 5 || object10[5] == 0)) {
                    object8 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.noCertSign");
                    this.addError((ErrorBundle)object8, i);
                }
            }
            object2 = x509Certificate;
            object3 = x509Certificate.getSubjectX500Principal();
            try {
                object5 = PKIXCertPathReviewer.getNextWorkingKey(this.certs, i);
                algorithmIdentifier = PKIXCertPathReviewer.getAlgorithmIdentifier((PublicKey)object5);
                object = algorithmIdentifier.getAlgorithm();
                aSN1Encodable = algorithmIdentifier.getParameters();
                continue;
            }
            catch (CertPathValidatorException certPathValidatorException) {
                object10 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.pubKeyError");
                this.addError((ErrorBundle)object10, i);
                algorithmIdentifier = null;
                object = null;
                aSN1Encodable = null;
            }
        }
        this.trustAnchor = trustAnchor;
        this.subjectPublicKey = object5;
    }

    /*
     * WARNING - void declaration
     */
    private void checkPolicy() {
        Set<String> set = this.pkixParams.getInitialPolicies();
        List[] listArray = new ArrayList[this.n + 1];
        for (int i = 0; i < listArray.length; ++i) {
            listArray[i] = new ArrayList();
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("2.5.29.32.0");
        PKIXPolicyNode pKIXPolicyNode = new PKIXPolicyNode(new ArrayList(), 0, hashSet, null, new HashSet(), "2.5.29.32.0", false);
        listArray[0].add(pKIXPolicyNode);
        int n = this.pkixParams.isExplicitPolicyRequired() ? 0 : this.n + 1;
        int n2 = this.pkixParams.isAnyPolicyInhibited() ? 0 : this.n + 1;
        int n3 = this.pkixParams.isPolicyMappingInhibited() ? 0 : this.n + 1;
        Object object = null;
        X509Certificate x509Certificate = null;
        try {
            Object certPathValidatorException;
            Object object3;
            Object object4;
            Object object5;
            int n4;
            for (n4 = this.certs.size() - 1; n4 >= 0; --n4) {
                int n5 = this.n - n4;
                x509Certificate = (X509Certificate)this.certs.get(n4);
                try {
                    object5 = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, CERTIFICATE_POLICIES);
                }
                catch (AnnotatedException annotatedException) {
                    object4 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.policyExtError");
                    throw new CertPathReviewerException((ErrorBundle)object4, (Throwable)annotatedException, this.certPath, n4);
                }
                if (object5 != null && pKIXPolicyNode != null) {
                    boolean n6;
                    Object object6;
                    Object object7;
                    Object object8;
                    object3 = object5.getObjects();
                    object4 = new HashSet();
                    while (object3.hasMoreElements()) {
                        object8 = PolicyInformation.getInstance(object3.nextElement());
                        object7 = object8.getPolicyIdentifier();
                        object4.add(object7.getId());
                        if ("2.5.29.32.0".equals(object7.getId())) continue;
                        try {
                            object6 = PKIXCertPathReviewer.getQualifierSet(object8.getPolicyQualifiers());
                        }
                        catch (CertPathValidatorException certPathValidatorException2) {
                            certPathValidatorException = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.policyQualifierError");
                            throw new CertPathReviewerException((ErrorBundle)certPathValidatorException, (Throwable)certPathValidatorException2, this.certPath, n4);
                        }
                        n6 = PKIXCertPathReviewer.processCertD1i(n5, listArray, (ASN1ObjectIdentifier)object7, object6);
                        if (n6) continue;
                        PKIXCertPathReviewer.processCertD1ii(n5, listArray, (ASN1ObjectIdentifier)object7, object6);
                    }
                    if (object == null || object.contains("2.5.29.32.0")) {
                        object = object4;
                    } else {
                        object8 = object.iterator();
                        object7 = new HashSet();
                        while (object8.hasNext()) {
                            object6 = object8.next();
                            if (!object4.contains(object6)) continue;
                            object7.add(object6);
                        }
                        object = object7;
                    }
                    if (n2 > 0 || n5 < this.n && PKIXCertPathReviewer.isSelfIssued(x509Certificate)) {
                        object3 = object5.getObjects();
                        while (object3.hasMoreElements()) {
                            void pKIXPolicyNode3;
                            object8 = PolicyInformation.getInstance(object3.nextElement());
                            if (!"2.5.29.32.0".equals(object8.getPolicyIdentifier().getId())) continue;
                            try {
                                object7 = PKIXCertPathReviewer.getQualifierSet(object8.getPolicyQualifiers());
                            }
                            catch (CertPathValidatorException certPathValidatorException3) {
                                ErrorBundle errorBundle = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.policyQualifierError");
                                throw new CertPathReviewerException(errorBundle, (Throwable)certPathValidatorException3, this.certPath, n4);
                            }
                            object6 = listArray[n5 - 1];
                            n6 = false;
                            while (pKIXPolicyNode3 < object6.size()) {
                                certPathValidatorException = (PKIXPolicyNode)object6.get((int)pKIXPolicyNode3);
                                for (Set set2 : ((PKIXPolicyNode)certPathValidatorException).getExpectedPolicies()) {
                                    Object object2;
                                    String string;
                                    if (set2 instanceof String) {
                                        string = (String)((Object)set2);
                                    } else {
                                        if (!(set2 instanceof ASN1ObjectIdentifier)) continue;
                                        string = ((ASN1ObjectIdentifier)set2).getId();
                                    }
                                    boolean bl = false;
                                    Iterator iterator = ((PKIXPolicyNode)certPathValidatorException).getChildren();
                                    while (iterator.hasNext()) {
                                        object2 = (PKIXPolicyNode)iterator.next();
                                        if (!string.equals(((PKIXPolicyNode)object2).getValidPolicy())) continue;
                                        bl = true;
                                    }
                                    if (bl) continue;
                                    object2 = new HashSet();
                                    object2.add(string);
                                    PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n5, (Set)object2, (PolicyNode)certPathValidatorException, (Set)object7, string, false);
                                    ((PKIXPolicyNode)certPathValidatorException).addChild(pKIXPolicyNode2);
                                    listArray[n5].add(pKIXPolicyNode2);
                                }
                                ++pKIXPolicyNode3;
                            }
                            break block30;
                        }
                    }
                    for (int i = n5 - 1; i >= 0; --i) {
                        object7 = listArray[i];
                        for (int j = 0; j < object7.size() && ((i = (PKIXPolicyNode)object7.get(j)).hasChildren() || (pKIXPolicyNode = PKIXCertPathReviewer.removePolicyNode(pKIXPolicyNode, listArray, i)) != null); ++j) {
                        }
                    }
                    Set<String> set3 = x509Certificate.getCriticalExtensionOIDs();
                    if (set3 != null) {
                        void aSN1Sequence;
                        boolean bl = set3.contains(CERTIFICATE_POLICIES);
                        List list = listArray[n5];
                        boolean aSN1ObjectIdentifier2 = false;
                        while (aSN1Sequence < list.size()) {
                            certPathValidatorException = (PKIXPolicyNode)list.get((int)aSN1Sequence);
                            ((PKIXPolicyNode)certPathValidatorException).setCritical(bl);
                            ++aSN1Sequence;
                        }
                    }
                }
                if (object5 == null) {
                    pKIXPolicyNode = null;
                }
                if (n <= 0 && pKIXPolicyNode == null) {
                    object3 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.noValidPolicyTree");
                    throw new CertPathReviewerException((ErrorBundle)object3);
                }
                if (n5 == this.n) continue;
                try {
                    object3 = PKIXCertPathReviewer.getExtensionValue(x509Certificate, POLICY_MAPPINGS);
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle errorBundle = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.policyMapExtError");
                    throw new CertPathReviewerException(errorBundle, (Throwable)annotatedException, this.certPath, n4);
                }
                if (object3 != null) {
                    object4 = (ASN1Sequence)object3;
                    for (int i = 0; i < object4.size(); ++i) {
                        ASN1Sequence aSN1Sequence = (ASN1Sequence)object4.getObjectAt(i);
                        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0);
                        ASN1ObjectIdentifier string = (ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(1);
                        if ("2.5.29.32.0".equals(aSN1ObjectIdentifier.getId())) {
                            certPathValidatorException = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.invalidPolicyMapping");
                            throw new CertPathReviewerException((ErrorBundle)certPathValidatorException, this.certPath, n4);
                        }
                        if (!"2.5.29.32.0".equals(string.getId())) continue;
                        certPathValidatorException = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.invalidPolicyMapping");
                        throw new CertPathReviewerException((ErrorBundle)certPathValidatorException, this.certPath, n4);
                    }
                }
                if (object3 != null) {
                    Iterator iterator;
                    object4 = (ASN1Sequence)object3;
                    HashMap hashMap = new HashMap();
                    HashSet<Object> hashSet2 = new HashSet<Object>();
                    for (int i = 0; i < object4.size(); ++i) {
                        Set set2;
                        ASN1Sequence iterator2 = (ASN1Sequence)object4.getObjectAt(i);
                        certPathValidatorException = ((ASN1ObjectIdentifier)iterator2.getObjectAt(0)).getId();
                        iterator = ((ASN1ObjectIdentifier)iterator2.getObjectAt(1)).getId();
                        if (!hashMap.containsKey(certPathValidatorException)) {
                            set2 = new HashSet();
                            set2.add(iterator);
                            hashMap.put(certPathValidatorException, set2);
                            hashSet2.add(certPathValidatorException);
                            continue;
                        }
                        set2 = (Set)hashMap.get(certPathValidatorException);
                        set2.add(iterator);
                    }
                    for (String pKIXPolicyNode6 : hashSet2) {
                        if (n3 > 0) {
                            try {
                                PKIXCertPathReviewer.prepareNextCertB1(n5, listArray, pKIXPolicyNode6, hashMap, x509Certificate);
                                continue;
                            }
                            catch (AnnotatedException annotatedException) {
                                iterator = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.policyExtError");
                                throw new CertPathReviewerException((ErrorBundle)((Object)iterator), (Throwable)annotatedException, this.certPath, n4);
                            }
                            catch (CertPathValidatorException certPathValidatorException4) {
                                iterator = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.policyQualifierError");
                                throw new CertPathReviewerException((ErrorBundle)((Object)iterator), (Throwable)certPathValidatorException4, this.certPath, n4);
                            }
                        }
                        if (n3 > 0) continue;
                        pKIXPolicyNode = PKIXCertPathReviewer.prepareNextCertB2(n5, listArray, pKIXPolicyNode6, pKIXPolicyNode);
                    }
                }
                if (!PKIXCertPathReviewer.isSelfIssued(x509Certificate)) {
                    if (n != 0) {
                        --n;
                    }
                    if (n3 != 0) {
                        --n3;
                    }
                    if (n2 != 0) {
                        --n2;
                    }
                }
                try {
                    object4 = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, POLICY_CONSTRAINTS);
                    if (object4 != null) {
                        Enumeration enumeration = object4.getObjects();
                        while (enumeration.hasMoreElements()) {
                            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
                            switch (aSN1TaggedObject.getTagNo()) {
                                case 0: {
                                    int n7 = ASN1Integer.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)false).intValueExact();
                                    if (n7 >= n) break;
                                    n = n7;
                                    break;
                                }
                                case 1: {
                                    int n7 = ASN1Integer.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)false).intValueExact();
                                    if (n7 >= n3) break;
                                    n3 = n7;
                                }
                            }
                        }
                    }
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle errorBundle = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.policyConstExtError");
                    throw new CertPathReviewerException(errorBundle, this.certPath, n4);
                }
                try {
                    int n8;
                    object4 = (ASN1Integer)PKIXCertPathReviewer.getExtensionValue(x509Certificate, INHIBIT_ANY_POLICY);
                    if (object4 == null || (n8 = object4.intValueExact()) >= n2) continue;
                    n2 = n8;
                    continue;
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle errorBundle = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.policyInhibitExtError");
                    throw new CertPathReviewerException(errorBundle, this.certPath, n4);
                }
            }
            if (!PKIXCertPathReviewer.isSelfIssued(x509Certificate) && n > 0) {
                --n;
            }
            try {
                object5 = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, POLICY_CONSTRAINTS);
                if (object5 != null) {
                    object3 = object5.getObjects();
                    while (object3.hasMoreElements()) {
                        object4 = (ASN1TaggedObject)object3.nextElement();
                        switch (object4.getTagNo()) {
                            case 0: {
                                int n9 = ASN1Integer.getInstance((ASN1TaggedObject)object4, (boolean)false).intValueExact();
                                if (n9 != 0) break;
                                n = 0;
                            }
                        }
                    }
                }
            }
            catch (AnnotatedException annotatedException) {
                object3 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.policyConstExtError");
                throw new CertPathReviewerException((ErrorBundle)object3, this.certPath, n4);
            }
            if (pKIXPolicyNode == null) {
                if (this.pkixParams.isExplicitPolicyRequired()) {
                    object3 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.explicitPolicy");
                    throw new CertPathReviewerException((ErrorBundle)object3, this.certPath, n4);
                }
                object5 = null;
            } else if (PKIXCertPathReviewer.isAnyPolicy(set)) {
                if (this.pkixParams.isExplicitPolicyRequired()) {
                    if (object.isEmpty()) {
                        object3 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.explicitPolicy");
                        throw new CertPathReviewerException((ErrorBundle)object3, this.certPath, n4);
                    }
                    object3 = new HashSet();
                    for (int i = 0; i < listArray.length; ++i) {
                        ArrayList arrayList = listArray[i];
                        for (int j = 0; j < arrayList.size(); ++j) {
                            PKIXPolicyNode pKIXPolicyNode4 = (PKIXPolicyNode)arrayList.get(j);
                            if (!"2.5.29.32.0".equals(pKIXPolicyNode4.getValidPolicy())) continue;
                            Iterator iterator = pKIXPolicyNode4.getChildren();
                            while (iterator.hasNext()) {
                                object3.add(iterator.next());
                            }
                        }
                    }
                    Iterator iterator = object3.iterator();
                    while (iterator.hasNext()) {
                        PKIXPolicyNode pKIXPolicyNode5 = (PKIXPolicyNode)iterator.next();
                        String string = pKIXPolicyNode5.getValidPolicy();
                        if (object.contains(string)) continue;
                    }
                    if (pKIXPolicyNode != null) {
                        for (int i = this.n - 1; i >= 0; --i) {
                            List list = listArray[i];
                            for (int j = 0; j < list.size(); ++j) {
                                PKIXPolicyNode pKIXPolicyNode9 = (PKIXPolicyNode)list.get(j);
                                if (pKIXPolicyNode9.hasChildren()) continue;
                                pKIXPolicyNode = PKIXCertPathReviewer.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode9);
                            }
                        }
                    }
                }
                object5 = pKIXPolicyNode;
            } else {
                object3 = new HashSet();
                for (int i = 0; i < listArray.length; ++i) {
                    ArrayList arrayList = listArray[i];
                    for (int j = 0; j < arrayList.size(); ++j) {
                        PKIXPolicyNode pKIXPolicyNode7 = (PKIXPolicyNode)arrayList.get(j);
                        if (!"2.5.29.32.0".equals(pKIXPolicyNode7.getValidPolicy())) continue;
                        Iterator iterator = pKIXPolicyNode7.getChildren();
                        while (iterator.hasNext()) {
                            certPathValidatorException = (PKIXPolicyNode)iterator.next();
                            if ("2.5.29.32.0".equals(((PKIXPolicyNode)certPathValidatorException).getValidPolicy())) continue;
                            object3.add(certPathValidatorException);
                        }
                    }
                }
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    PKIXPolicyNode pKIXPolicyNode8 = (PKIXPolicyNode)iterator.next();
                    String string = pKIXPolicyNode8.getValidPolicy();
                    if (set.contains(string)) continue;
                    pKIXPolicyNode = PKIXCertPathReviewer.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode8);
                }
                if (pKIXPolicyNode != null) {
                    for (int i = this.n - 1; i >= 0; --i) {
                        ArrayList arrayList = listArray[i];
                        for (int j = 0; j < arrayList.size(); ++j) {
                            PKIXPolicyNode pKIXPolicyNode3 = (PKIXPolicyNode)arrayList.get(j);
                            if (pKIXPolicyNode3.hasChildren()) continue;
                            pKIXPolicyNode = PKIXCertPathReviewer.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode3);
                        }
                    }
                }
                object5 = pKIXPolicyNode;
            }
            if (n <= 0 && object5 == null) {
                object3 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.invalidPolicy");
                throw new CertPathReviewerException((ErrorBundle)object3);
            }
            pKIXPolicyNode = object5;
        }
        catch (CertPathReviewerException certPathReviewerException) {
            this.addError(certPathReviewerException.getErrorMessage(), certPathReviewerException.getIndex());
            pKIXPolicyNode = null;
        }
    }

    private void checkCriticalExtensions() {
        List<PKIXCertPathChecker> list = this.pkixParams.getCertPathCheckers();
        Iterator<PKIXCertPathChecker> iterator = list.iterator();
        try {
            try {
                while (iterator.hasNext()) {
                    iterator.next().init(false);
                }
            }
            catch (CertPathValidatorException certPathValidatorException) {
                ErrorBundle errorBundle = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.certPathCheckerError", new Object[]{certPathValidatorException.getMessage(), certPathValidatorException, certPathValidatorException.getClass().getName()});
                throw new CertPathReviewerException(errorBundle, (Throwable)certPathValidatorException);
            }
            X509Certificate x509Certificate = null;
            for (int i = this.certs.size() - 1; i >= 0; --i) {
                Object object;
                x509Certificate = (X509Certificate)this.certs.get(i);
                Set<String> set = x509Certificate.getCriticalExtensionOIDs();
                if (set == null || set.isEmpty()) continue;
                set.remove(KEY_USAGE);
                set.remove(CERTIFICATE_POLICIES);
                set.remove(POLICY_MAPPINGS);
                set.remove(INHIBIT_ANY_POLICY);
                set.remove(ISSUING_DISTRIBUTION_POINT);
                set.remove(DELTA_CRL_INDICATOR);
                set.remove(POLICY_CONSTRAINTS);
                set.remove(BASIC_CONSTRAINTS);
                set.remove(SUBJECT_ALTERNATIVE_NAME);
                set.remove(NAME_CONSTRAINTS);
                if (i == 0) {
                    set.remove(Extension.extendedKeyUsage.getId());
                }
                if (set.contains(QC_STATEMENT) && this.processQcStatements(x509Certificate, i)) {
                    set.remove(QC_STATEMENT);
                }
                Iterator<PKIXCertPathChecker> iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    try {
                        iterator2.next().check(x509Certificate, set);
                    }
                    catch (CertPathValidatorException certPathValidatorException) {
                        object = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.criticalExtensionError", new Object[]{certPathValidatorException.getMessage(), certPathValidatorException, certPathValidatorException.getClass().getName()});
                        throw new CertPathReviewerException((ErrorBundle)object, certPathValidatorException.getCause(), this.certPath, i);
                    }
                }
                if (set.isEmpty()) continue;
                object = set.iterator();
                while (object.hasNext()) {
                    ErrorBundle errorBundle = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.unknownCriticalExt", new Object[]{new ASN1ObjectIdentifier(object.next())});
                    this.addError(errorBundle, i);
                }
            }
        }
        catch (CertPathReviewerException certPathReviewerException) {
            this.addError(certPathReviewerException.getErrorMessage(), certPathReviewerException.getIndex());
        }
    }

    private boolean processQcStatements(X509Certificate x509Certificate, int n) {
        try {
            boolean bl = false;
            ASN1Sequence aSN1Sequence = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, QC_STATEMENT);
            for (int i = 0; i < aSN1Sequence.size(); ++i) {
                ErrorBundle errorBundle;
                QCStatement qCStatement = QCStatement.getInstance((Object)aSN1Sequence.getObjectAt(i));
                if (QCStatement.id_etsi_qcs_QcCompliance.equals((ASN1Primitive)qCStatement.getStatementId())) {
                    errorBundle = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.QcEuCompliance");
                    this.addNotification(errorBundle, n);
                    continue;
                }
                if (QCStatement.id_qcs_pkixQCSyntax_v1.equals((ASN1Primitive)qCStatement.getStatementId())) continue;
                if (QCStatement.id_etsi_qcs_QcSSCD.equals((ASN1Primitive)qCStatement.getStatementId())) {
                    errorBundle = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.QcSSCD");
                    this.addNotification(errorBundle, n);
                    continue;
                }
                if (QCStatement.id_etsi_qcs_LimiteValue.equals((ASN1Primitive)qCStatement.getStatementId())) {
                    errorBundle = MonetaryValue.getInstance((Object)qCStatement.getStatementInfo());
                    Iso4217CurrencyCode iso4217CurrencyCode = errorBundle.getCurrency();
                    double d = errorBundle.getAmount().doubleValue() * Math.pow(10.0, errorBundle.getExponent().doubleValue());
                    ErrorBundle errorBundle2 = errorBundle.getCurrency().isAlphabetic() ? PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.QcLimitValueAlpha", new Object[]{errorBundle.getCurrency().getAlphabetic(), new TrustedInput(new Double(d)), errorBundle}) : PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.QcLimitValueNum", new Object[]{Integers.valueOf((int)errorBundle.getCurrency().getNumeric()), new TrustedInput(new Double(d)), errorBundle});
                    this.addNotification(errorBundle2, n);
                    continue;
                }
                errorBundle = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.QcUnknownStatement", new Object[]{qCStatement.getStatementId(), new UntrustedInput(qCStatement)});
                this.addNotification(errorBundle, n);
                bl = true;
            }
            return !bl;
        }
        catch (AnnotatedException annotatedException) {
            ErrorBundle errorBundle = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.QcStatementExtError");
            this.addError(errorBundle, n);
            return false;
        }
    }

    private String IPtoString(byte[] byArray) {
        String string;
        try {
            string = InetAddress.getByAddress(byArray).getHostAddress();
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i != byArray.length; ++i) {
                stringBuilder.append(Integer.toHexString(byArray[i] & 0xFF));
                stringBuilder.append(' ');
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    protected void checkRevocation(PKIXParameters pKIXParameters, X509Certificate x509Certificate, Date date, X509Certificate x509Certificate2, PublicKey publicKey, Vector vector, Vector vector2, int n) throws CertPathReviewerException {
        this.checkCRLs(pKIXParameters, x509Certificate, date, x509Certificate2, publicKey, vector, n);
    }

    protected void checkCRLs(PKIXParameters pKIXParameters, X509Certificate x509Certificate, Date date, X509Certificate x509Certificate2, PublicKey publicKey, Vector vector, int n) throws CertPathReviewerException {
        ErrorBundle errorBundle;
        Object object;
        Iterator iterator;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Iterator iterator2;
        X509CRLStoreSelector x509CRLStoreSelector = new X509CRLStoreSelector();
        try {
            x509CRLStoreSelector.addIssuerName(PKIXCertPathReviewer.getEncodedIssuerPrincipal(x509Certificate).getEncoded());
        }
        catch (IOException iOException) {
            ErrorBundle errorBundle2 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.crlIssuerException");
            throw new CertPathReviewerException(errorBundle2, (Throwable)iOException);
        }
        x509CRLStoreSelector.setCertificateChecking(x509Certificate);
        try {
            Set set = PKIXCRLUtil.findCRLs(x509CRLStoreSelector, pKIXParameters);
            iterator2 = set.iterator();
            if (set.isEmpty()) {
                set = PKIXCRLUtil.findCRLs(new X509CRLStoreSelector(), pKIXParameters);
                object7 = set.iterator();
                object6 = new ArrayList();
                while (object7.hasNext()) {
                    object6.add(((X509CRL)object7.next()).getIssuerX500Principal());
                }
                int n2 = object6.size();
                object5 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.noCrlInCertstore", new Object[]{new UntrustedInput(x509CRLStoreSelector.getIssuerNames()), new UntrustedInput(object6), Integers.valueOf((int)n2)});
                this.addNotification((ErrorBundle)object5, n);
            }
        }
        catch (AnnotatedException annotatedException) {
            object7 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.crlExtractionError", new Object[]{annotatedException.getCause().getMessage(), annotatedException.getCause(), annotatedException.getCause().getClass().getName()});
            this.addError((ErrorBundle)object7, n);
            iterator2 = new ArrayList().iterator();
        }
        boolean bl = false;
        object7 = null;
        while (iterator2.hasNext()) {
            object7 = (X509CRL)iterator2.next();
            object6 = ((X509CRL)object7).getThisUpdate();
            Date date2 = ((X509CRL)object7).getNextUpdate();
            object5 = new ASN1Enumerated[]{new TrustedInput(object6), new TrustedInput(date2)};
            if (date2 == null || date.before(date2)) {
                bl = true;
                object4 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.localValidCRL", (Object[])object5);
                this.addNotification((ErrorBundle)object4, n);
                break;
            }
            object4 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.localInvalidCRL", (Object[])object5);
            this.addNotification((ErrorBundle)object4, n);
        }
        if (!bl) {
            object6 = x509Certificate.getIssuerX500Principal();
            X509CRL x509CRL = null;
            object5 = vector.iterator();
            while (object5.hasNext()) {
                try {
                    object4 = (String)object5.next();
                    x509CRL = this.getCRL((String)object4);
                    if (x509CRL == null) continue;
                    object3 = x509CRL.getIssuerX500Principal();
                    if (!((X500Principal)object6).equals(object3)) {
                        object2 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.onlineCRLWrongCA", new Object[]{new UntrustedInput(((X500Principal)object3).getName()), new UntrustedInput(((X500Principal)object6).getName()), new UntrustedUrlInput(object4)});
                        this.addNotification((ErrorBundle)object2, n);
                        continue;
                    }
                    object2 = x509CRL.getThisUpdate();
                    iterator = x509CRL.getNextUpdate();
                    object = new Object[]{new TrustedInput(object2), new TrustedInput(iterator), new UntrustedUrlInput(object4)};
                    if (iterator == null || date.before((Date)((Object)iterator))) {
                        bl = true;
                        errorBundle = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.onlineValidCRL", object);
                        this.addNotification(errorBundle, n);
                        object7 = x509CRL;
                        break;
                    }
                    errorBundle = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.onlineInvalidCRL", object);
                    this.addNotification(errorBundle, n);
                }
                catch (CertPathReviewerException certPathReviewerException) {
                    this.addNotification(certPathReviewerException.getErrorMessage(), n);
                }
            }
        }
        if (object7 != null) {
            Object object8;
            boolean[] blArray;
            if (!(x509Certificate2 == null || (blArray = x509Certificate2.getKeyUsage()) == null || blArray.length > 6 && blArray[6])) {
                object5 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.noCrlSigningPermited");
                throw new CertPathReviewerException((ErrorBundle)object5);
            }
            if (publicKey != null) {
                try {
                    ((X509CRL)object7).verify(publicKey, "BC");
                }
                catch (Exception exception) {
                    object5 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.crlVerifyFailed");
                    throw new CertPathReviewerException((ErrorBundle)object5, (Throwable)exception);
                }
            } else {
                ErrorBundle errorBundle3 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.crlNoIssuerPublicKey");
                throw new CertPathReviewerException(errorBundle3);
            }
            object6 = ((X509CRL)object7).getRevokedCertificate(x509Certificate.getSerialNumber());
            if (object6 != null) {
                object8 = null;
                if (((X509CRLEntry)object6).hasExtensions()) {
                    try {
                        object5 = ASN1Enumerated.getInstance((Object)PKIXCertPathReviewer.getExtensionValue((X509Extension)object6, Extension.reasonCode.getId()));
                    }
                    catch (AnnotatedException annotatedException) {
                        object3 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.crlReasonExtError");
                        throw new CertPathReviewerException((ErrorBundle)object3, (Throwable)annotatedException);
                    }
                    if (object5 != null) {
                        object8 = crlReasons[object5.intValueExact()];
                    }
                }
                if (object8 == null) {
                    object8 = crlReasons[7];
                }
                object5 = new LocaleString(RESOURCE_NAME, (String)object8);
                if (!date.before(((X509CRLEntry)object6).getRevocationDate())) {
                    object4 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.certRevoked", new Object[]{new TrustedInput(((X509CRLEntry)object6).getRevocationDate()), object5});
                    throw new CertPathReviewerException((ErrorBundle)object4);
                }
                object4 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.revokedAfterValidation", new Object[]{new TrustedInput(((X509CRLEntry)object6).getRevocationDate()), object5});
                this.addNotification((ErrorBundle)object4, n);
            } else {
                object8 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.notRevoked");
                this.addNotification((ErrorBundle)object8, n);
            }
            object8 = ((X509CRL)object7).getNextUpdate();
            if (object8 != null && !date.before((Date)object8)) {
                object5 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.crlUpdateAvailable", new Object[]{new TrustedInput(object8)});
                this.addNotification((ErrorBundle)object5, n);
            }
            try {
                object5 = PKIXCertPathReviewer.getExtensionValue((X509Extension)object7, ISSUING_DISTRIBUTION_POINT);
            }
            catch (AnnotatedException annotatedException) {
                object3 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.distrPtExtError");
                throw new CertPathReviewerException((ErrorBundle)object3);
            }
            try {
                object4 = PKIXCertPathReviewer.getExtensionValue((X509Extension)object7, DELTA_CRL_INDICATOR);
            }
            catch (AnnotatedException annotatedException) {
                object2 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.deltaCrlExtError");
                throw new CertPathReviewerException((ErrorBundle)object2);
            }
            if (object4 != null) {
                object3 = new X509CRLStoreSelector();
                try {
                    ((X509CRLSelector)object3).addIssuerName(PKIXCertPathReviewer.getIssuerPrincipal((X509CRL)object7).getEncoded());
                }
                catch (IOException iOException) {
                    iterator = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.crlIssuerException");
                    throw new CertPathReviewerException((ErrorBundle)((Object)iterator), (Throwable)iOException);
                }
                ((X509CRLSelector)object3).setMinCRLNumber(((ASN1Integer)object4).getPositiveValue());
                try {
                    ((X509CRLSelector)object3).setMaxCRLNumber(((ASN1Integer)PKIXCertPathReviewer.getExtensionValue((X509Extension)object7, CRL_NUMBER)).getPositiveValue().subtract(BigInteger.valueOf(1L)));
                }
                catch (AnnotatedException annotatedException) {
                    iterator = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.crlNbrExtError");
                    throw new CertPathReviewerException((ErrorBundle)((Object)iterator), (Throwable)annotatedException);
                }
                boolean bl2 = false;
                try {
                    iterator = PKIXCRLUtil.findCRLs((X509CRLStoreSelector)object3, pKIXParameters).iterator();
                }
                catch (AnnotatedException annotatedException) {
                    errorBundle = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.crlExtractionError");
                    throw new CertPathReviewerException(errorBundle, (Throwable)annotatedException);
                }
                while (iterator.hasNext()) {
                    object = (X509CRL)iterator.next();
                    try {
                        errorBundle = PKIXCertPathReviewer.getExtensionValue((X509Extension)object, ISSUING_DISTRIBUTION_POINT);
                    }
                    catch (AnnotatedException annotatedException) {
                        ErrorBundle errorBundle4 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.distrPtExtError");
                        throw new CertPathReviewerException(errorBundle4, (Throwable)annotatedException);
                    }
                    if (!Objects.areEqual((Object)object5, (Object)errorBundle)) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    object = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.noBaseCRL");
                    throw new CertPathReviewerException((ErrorBundle)object);
                }
            }
            if (object5 != null) {
                object3 = IssuingDistributionPoint.getInstance((Object)object5);
                BasicConstraints basicConstraints = null;
                try {
                    basicConstraints = BasicConstraints.getInstance((Object)PKIXCertPathReviewer.getExtensionValue(x509Certificate, BASIC_CONSTRAINTS));
                }
                catch (AnnotatedException annotatedException) {
                    object = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.crlBCExtError");
                    throw new CertPathReviewerException((ErrorBundle)object, (Throwable)annotatedException);
                }
                if (object3.onlyContainsUserCerts() && basicConstraints != null && basicConstraints.isCA()) {
                    iterator = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.crlOnlyUserCert");
                    throw new CertPathReviewerException((ErrorBundle)((Object)iterator));
                }
                if (object3.onlyContainsCACerts() && (basicConstraints == null || !basicConstraints.isCA())) {
                    iterator = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.crlOnlyCaCert");
                    throw new CertPathReviewerException((ErrorBundle)((Object)iterator));
                }
                if (object3.onlyContainsAttributeCerts()) {
                    iterator = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.crlOnlyAttrCert");
                    throw new CertPathReviewerException((ErrorBundle)((Object)iterator));
                }
            }
        }
        if (!bl) {
            ErrorBundle errorBundle5 = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.noValidCrlFound");
            throw new CertPathReviewerException(errorBundle5);
        }
    }

    protected Vector getCRLDistUrls(CRLDistPoint cRLDistPoint) {
        Vector<String> vector = new Vector<String>();
        if (cRLDistPoint != null) {
            DistributionPoint[] distributionPointArray = cRLDistPoint.getDistributionPoints();
            for (int i = 0; i < distributionPointArray.length; ++i) {
                DistributionPointName distributionPointName = distributionPointArray[i].getDistributionPoint();
                if (distributionPointName.getType() != 0) continue;
                GeneralName[] generalNameArray = GeneralNames.getInstance((Object)distributionPointName.getName()).getNames();
                for (int j = 0; j < generalNameArray.length; ++j) {
                    if (generalNameArray[j].getTagNo() != 6) continue;
                    String string = ((ASN1IA5String)generalNameArray[j].getName()).getString();
                    vector.add(string);
                }
            }
        }
        return vector;
    }

    protected Vector getOCSPUrls(AuthorityInformationAccess authorityInformationAccess) {
        Vector<String> vector = new Vector<String>();
        if (authorityInformationAccess != null) {
            AccessDescription[] accessDescriptionArray = authorityInformationAccess.getAccessDescriptions();
            for (int i = 0; i < accessDescriptionArray.length; ++i) {
                GeneralName generalName;
                if (!accessDescriptionArray[i].getAccessMethod().equals((ASN1Primitive)AccessDescription.id_ad_ocsp) || (generalName = accessDescriptionArray[i].getAccessLocation()).getTagNo() != 6) continue;
                String string = ((ASN1IA5String)generalName.getName()).getString();
                vector.add(string);
            }
        }
        return vector;
    }

    private X509CRL getCRL(String string) throws CertPathReviewerException {
        X509CRL x509CRL;
        block3: {
            x509CRL = null;
            try {
                URL uRL = new URL(string);
                if (!uRL.getProtocol().equals("http") && !uRL.getProtocol().equals("https")) break block3;
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setDoInput(true);
                httpURLConnection.connect();
                if (httpURLConnection.getResponseCode() == 200) {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
                    x509CRL = (X509CRL)certificateFactory.generateCRL(httpURLConnection.getInputStream());
                    break block3;
                }
                throw new Exception(httpURLConnection.getResponseMessage());
            }
            catch (Exception exception) {
                ErrorBundle errorBundle = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.loadCrlDistPointError", new Object[]{new UntrustedInput(string), exception.getMessage(), exception, exception.getClass().getName()});
                throw new CertPathReviewerException(errorBundle);
            }
        }
        return x509CRL;
    }

    protected Collection getTrustAnchors(X509Certificate x509Certificate, Set set) throws CertPathReviewerException {
        Serializable serializable;
        Object object;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = set.iterator();
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            x509CertSelector.setSubject(PKIXCertPathReviewer.getEncodedIssuerPrincipal(x509Certificate).getEncoded());
            object2 = x509Certificate.getExtensionValue(Extension.authorityKeyIdentifier.getId());
            if (object2 != null) {
                object = AuthorityKeyIdentifier.getInstance((Object)JcaX509ExtensionUtils.parseExtensionValue((byte[])object2));
                serializable = object.getAuthorityCertSerialNumber();
                if (serializable != null) {
                    x509CertSelector.setSerialNumber(object.getAuthorityCertSerialNumber());
                } else {
                    ASN1OctetString aSN1OctetString = object.getKeyIdentifierObject();
                    if (aSN1OctetString != null) {
                        x509CertSelector.setSubjectKeyIdentifier(aSN1OctetString.getEncoded("DER"));
                    }
                }
            }
        }
        catch (IOException iOException) {
            ErrorBundle errorBundle = PKIXCertPathReviewer.createErrorBundle("CertPathReviewer.trustAnchorIssuerError");
            throw new CertPathReviewerException(errorBundle);
        }
        while (iterator.hasNext()) {
            object2 = (TrustAnchor)iterator.next();
            if (((TrustAnchor)object2).getTrustedCert() != null) {
                if (!x509CertSelector.match(((TrustAnchor)object2).getTrustedCert())) continue;
                arrayList.add(object2);
                continue;
            }
            if (((TrustAnchor)object2).getCAName() == null || ((TrustAnchor)object2).getCAPublicKey() == null || !((X500Principal)(object = PKIXCertPathReviewer.getEncodedIssuerPrincipal(x509Certificate))).equals(serializable = new X500Principal(((TrustAnchor)object2).getCAName()))) continue;
            arrayList.add(object2);
        }
        return arrayList;
    }

    private static ErrorBundle createErrorBundle(String string) {
        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, string);
        errorBundle.setClassLoader(PKIXCertPathReviewer.class.getClassLoader());
        return errorBundle;
    }

    private static ErrorBundle createErrorBundle(String string, Object[] objectArray) {
        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, string, objectArray);
        errorBundle.setClassLoader(PKIXCertPathReviewer.class.getClassLoader());
        return errorBundle;
    }
}

