/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component.behavior;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.behavior.BehaviorBase;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorContext;
import jakarta.faces.component.behavior.ClientBehaviorHint;
import jakarta.faces.context.FacesContext;
import jakarta.faces.render.ClientBehaviorRenderer;
import jakarta.faces.render.RenderKit;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClientBehaviorBase
extends BehaviorBase
implements ClientBehavior {
    private static final Logger logger = Logger.getLogger("jakarta.faces.component.behavior", "jakarta.faces.LogStrings");

    @Override
    public String getScript(ClientBehaviorContext behaviorContext) {
        if (null == behaviorContext) {
            throw new NullPointerException();
        }
        ClientBehaviorRenderer renderer = this.getRenderer(behaviorContext.getFacesContext());
        String script = null;
        if (null != renderer) {
            script = renderer.getScript(behaviorContext, this);
        }
        return script;
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        if (null == context || null == component) {
            throw new NullPointerException();
        }
        ClientBehaviorRenderer renderer = this.getRenderer(context);
        if (null != renderer) {
            renderer.decode(context, component, this);
        }
    }

    public String getRendererType() {
        return null;
    }

    @Override
    public Set<ClientBehaviorHint> getHints() {
        return Collections.emptySet();
    }

    protected ClientBehaviorRenderer getRenderer(FacesContext context) {
        if (null == context) {
            throw new NullPointerException();
        }
        ClientBehaviorRenderer renderer = null;
        String rendererType = this.getRendererType();
        if (null != rendererType) {
            RenderKit renderKit = context.getRenderKit();
            if (null != renderKit) {
                renderer = renderKit.getClientBehaviorRenderer(rendererType);
            }
            if (null == renderer && logger.isLoggable(Level.FINE)) {
                logger.fine("Can't get  behavior renderer for type " + rendererType);
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("No renderer-type for behavior " + this.getClass().getName());
        }
        return renderer;
    }
}

