/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.ee;

import jakarta.transaction.TransactionManager;
import org.apache.openjpa.ee.AbstractManagedRuntime;
import org.apache.openjpa.util.InternalException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class OSGiManagedRuntime
extends AbstractManagedRuntime {
    private static TransactionManager transactionManager;
    private static ServiceReference serviceReference;
    private static ServiceListener listener;

    public static synchronized void registerServiceListener(BundleContext bundleContext) throws InvalidSyntaxException {
        if (listener != null) {
            throw new InternalException("Another OSGi service listener has already been registered.");
        }
        listener = new Listener(bundleContext);
        bundleContext.addServiceListener(listener, "(objectClass=jakarta.transaction.TransactionManager)");
        serviceReference = bundleContext.getServiceReference("jakarta.transaction.TransactionManager");
        if (serviceReference != null) {
            transactionManager = (TransactionManager)bundleContext.getService(serviceReference);
        }
    }

    public static synchronized void deregisterServiceListener(BundleContext bundleContext) {
        try {
            if (serviceReference != null) {
                bundleContext.ungetService(serviceReference);
                transactionManager = null;
                serviceReference = null;
            }
        }
        finally {
            if (listener != null) {
                bundleContext.removeServiceListener(listener);
                listener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionManager getTransactionManager() throws Exception {
        Class<OSGiManagedRuntime> clazz = OSGiManagedRuntime.class;
        synchronized (OSGiManagedRuntime.class) {
            if (transactionManager == null) {
                throw new InternalException("No jakarta.transaction.TransactionManager service is currently registered as an OSGi service.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return transactionManager;
        }
    }

    @Override
    public void setRollbackOnly(Throwable cause) throws Exception {
        this.getTransactionManager().getTransaction().setRollbackOnly();
    }

    @Override
    public Throwable getRollbackCause() throws Exception {
        return null;
    }

    private static final class Listener
    implements ServiceListener {
        final BundleContext bundleContext;
        final Class<OSGiManagedRuntime> clazzRef;

        public Listener(BundleContext bundleContext) {
            this.bundleContext = bundleContext;
            this.clazzRef = OSGiManagedRuntime.class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceChanged(ServiceEvent event) {
            Class<OSGiManagedRuntime> clazz = this.clazzRef;
            synchronized (clazz) {
                switch (event.getType()) {
                    case 1: {
                        serviceReference = event.getServiceReference();
                        transactionManager = (TransactionManager)this.bundleContext.getService(serviceReference);
                        break;
                    }
                    case 4: {
                        transactionManager = null;
                        serviceReference = null;
                        this.bundleContext.ungetService(event.getServiceReference());
                    }
                }
            }
        }
    }
}

