/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.security;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.security.Securable;

public final class JCEEncryptor
implements Securable {
    private static final byte IV_GCM_LENGTH = 16;
    private static final String AES_GCM = "AES/GCM/NoPadding";
    private final Cipher encryptCipherAES_GCM = Cipher.getInstance("AES/GCM/NoPadding");
    private final Cipher decryptCipherAES_GCM = Cipher.getInstance("AES/GCM/NoPadding");

    @Override
    public synchronized String encryptPassword(String password) {
        try {
            byte[] ivGCM = Synergizer.getIvGCM();
            GCMParameterSpec parameterSpecGCM = new GCMParameterSpec(128, ivGCM);
            SecretKey skGCM = Synergizer.getAESGCMMultitasker();
            this.encryptCipherAES_GCM.init(1, (Key)skGCM, parameterSpecGCM);
            byte[] bytePassword = this.encryptCipherAES_GCM.doFinal(password.getBytes("UTF-8"));
            byte[] result = Arrays.copyOf(ivGCM, 16 + bytePassword.length);
            System.arraycopy(bytePassword, 0, result, 16, bytePassword.length);
            return Helper.buildHexStringFromBytes(result);
        }
        catch (Exception e) {
            throw ValidationException.errorEncryptingPassword(e);
        }
    }

    @Override
    public synchronized String decryptPassword(String encryptedPswd) {
        if (encryptedPswd == null) {
            return null;
        }
        String password = null;
        byte[] input = null;
        byte[] bytePassword = null;
        try {
            input = Helper.buildBytesFromHexString(encryptedPswd);
            SecretKey skGCM = Synergizer.getAESGCMMultitasker();
            byte[] ivGCM = new byte[16];
            System.arraycopy(input, 0, ivGCM, 0, 16);
            GCMParameterSpec parameterSpecGCM = new GCMParameterSpec(128, ivGCM);
            bytePassword = new byte[input.length - 16];
            System.arraycopy(input, 16, bytePassword, 0, input.length - 16);
            this.decryptCipherAES_GCM.init(2, (Key)skGCM, parameterSpecGCM);
            password = new String(this.decryptCipherAES_GCM.doFinal(bytePassword), StandardCharsets.UTF_8);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException | IllegalBlockSizeException | ConversionException ce) {
            password = encryptedPswd;
        }
        catch (Exception u) {
            throw ValidationException.errorDecryptingPasswordOldAlgorithm(u);
        }
        return password;
    }

    private static class Synergizer {
        private Synergizer() {
        }

        private static SecretKey getAESGCMMultitasker() throws Exception {
            return new SecretKeySpec(Helper.buildBytesFromHexString("64EF2D9B738ACA254A48F14754030FC2"), "AES");
        }

        private static byte[] getIvGCM() {
            byte[] ivGCM = new byte[16];
            SecureRandom random = null;
            String useStrongRNG = PrivilegedAccessHelper.getSystemProperty("eclipselink.security.encryptor.use.strong.random.number.generator");
            if (useStrongRNG == null || useStrongRNG.equalsIgnoreCase("false")) {
                random = new SecureRandom();
            } else if (useStrongRNG.equalsIgnoreCase("true")) {
                try {
                    random = SecureRandom.getInstanceStrong();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            } else {
                throw ValidationException.invalidBooleanValueForProperty(useStrongRNG, "eclipselink.security.encryptor.use.strong.random.number.generator");
            }
            random.nextBytes(ivGCM);
            return ivGCM;
        }
    }
}

