/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.jce.crypto.algo;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.fulcrum.jce.crypto.StreamUtil;
import org.apache.fulcrum.jce.crypto.extended.CryptoParametersJ8;
import org.apache.fulcrum.jce.crypto.extended.CryptoStreamFactoryJ8Template;

public final class CryptoStreamGCMImpl
extends CryptoStreamFactoryJ8Template {
    protected static final int IV_SIZE = 12;

    public CryptoStreamGCMImpl() throws GeneralSecurityException {
        this(CryptoStreamGCMImpl.generateSalt());
    }

    public CryptoStreamGCMImpl(byte[] salt) {
        this.setSalt(salt);
        this.providerName = PROVIDERNAME;
        this.setType(CryptoParametersJ8.TYPES.GCM);
        this.algorithm = CryptoParametersJ8.TYPES_IMPL.ALGORITHM_J8_GCM.getAlgorithm();
    }

    @Override
    protected Key createKey(char[] password, byte[] salt) throws GeneralSecurityException {
        SecretKeySpec key = new SecretKeySpec(salt == null ? this.getSalt() : (byte[])salt.clone(), "AES");
        return key;
    }

    @Override
    protected byte[] createCipher(InputStream is, int mode, char[] password) throws GeneralSecurityException, IOException {
        GCMParameterSpec gcmParamSpec;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        StreamUtil.copy(is, bos);
        byte[] input = bos.toByteArray();
        byte[] ciphertext = null;
        byte[] salt = null;
        byte[] iv = null;
        if (mode == 2) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(input);
            salt = new byte[16];
            byteBuffer.get(salt);
            iv = new byte[12];
            byteBuffer.get(iv);
            ciphertext = new byte[byteBuffer.remaining()];
            byteBuffer.get(ciphertext);
        }
        Key key = this.createKey(password, salt);
        Cipher cipher = this.getProviderName() == null ? Cipher.getInstance(this.getAlgorithm()) : Cipher.getInstance(this.getAlgorithm(), this.getProviderName());
        if (mode == 2) {
            gcmParamSpec = new GCMParameterSpec(128, iv);
            cipher.init(mode, key, gcmParamSpec);
            ciphertext = cipher.doFinal(ciphertext);
        }
        if (mode == 1) {
            iv = this.generateIV();
            gcmParamSpec = new GCMParameterSpec(128, iv);
            salt = this.getSalt();
            cipher.init(mode, key, gcmParamSpec);
            byte[] result = cipher.doFinal(input);
            ByteBuffer byteBuffer = ByteBuffer.allocate(salt.length + iv.length + result.length);
            ciphertext = byteBuffer.put(salt).put(iv).put(result).array();
        }
        return ciphertext;
    }

    private byte[] generateIV() throws GeneralSecurityException {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            byte[] iv = new byte[12];
            random.nextBytes(iv);
            return iv;
        }
        catch (NoSuchAlgorithmException e) {
            throw new GeneralSecurityException(e);
        }
    }
}

