/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta;

import java.util.HashMap;
import java.util.Map;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.RutaElement;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.ScriptApply;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RutaModule
extends RutaElement {
    private final RutaBlock rootBlock;
    private Map<String, RutaModule> scripts;
    private Map<String, AnalysisEngine> engines;
    private Map<String, RutaBlock> blocks;

    public RutaModule(RutaBlock rootBlock) {
        this.rootBlock = rootBlock;
        this.scripts = new HashMap<String, RutaModule>();
        this.engines = new HashMap<String, AnalysisEngine>();
        this.blocks = new HashMap<String, RutaBlock>();
    }

    public ScriptApply apply(RutaStream stream, InferenceCrowd crowd) {
        crowd.beginVisit(this, null);
        ScriptApply result = this.rootBlock.apply(stream, crowd);
        crowd.endVisit(this, result);
        return result;
    }

    public RutaBlock getBlock(String id) {
        if (id == null || id.equals(this.rootBlock.getName())) {
            return this.rootBlock;
        }
        return this.blocks.get(id);
    }

    public RutaModule getScript(String name) {
        if (name.equals(this.rootBlock.getName())) {
            return this;
        }
        RutaModule result = this.scripts.get(name);
        if (result == null) {
            for (String each : this.scripts.keySet()) {
                String[] split = each.split("\\.");
                String last = split[split.length - 1];
                if (!last.equals(name)) continue;
                return this.scripts.get(each);
            }
        }
        return result;
    }

    public void addScript(String name, RutaModule script) {
        this.scripts.put(name, script);
    }

    public void addBlock(String id, RutaBlock block) {
        this.blocks.put(id, block);
    }

    public void setScriptDependencies(Map<String, RutaModule> additionalScripts) {
        for (String eachTarget : this.scripts.keySet()) {
            RutaModule module = additionalScripts.get(eachTarget);
            this.addScript(eachTarget, module);
        }
    }

    public AnalysisEngine getEngine(String name) {
        AnalysisEngine result = this.engines.get(name);
        if (result == null) {
            for (String each : this.engines.keySet()) {
                String[] split = each.split("\\.");
                String last = split[split.length - 1];
                if (!last.equals(name)) continue;
                return this.engines.get(each);
            }
        }
        return result;
    }

    public void addEngine(String name, AnalysisEngine engine) {
        this.engines.put(name, engine);
    }

    public void setEngineDependencies(Map<String, AnalysisEngine> additionalEngines) {
        for (String eachTarget : this.engines.keySet()) {
            AnalysisEngine engine = additionalEngines.get(eachTarget);
            this.addEngine(eachTarget, engine);
        }
    }

    public Map<String, RutaModule> getScripts() {
        return this.scripts;
    }

    public Map<String, RutaBlock> getBlocks() {
        return this.blocks;
    }

    public Map<String, AnalysisEngine> getEngines() {
        return this.engines;
    }

    public RutaBlock getRootBlock() {
        return this.rootBlock;
    }
}

